package com.koossery.workflow.credit.backingbean.creditform;


import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.AlfrescoNavigationHandler;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.workflow.ManageTaskDialog;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

import sun.security.krb5.internal.UDPClient;

import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.data.CreditRecordData;
import com.koossery.workflow.credit.data.GenerateContratData;
import com.koossery.workflow.credit.data.ScanContratData;

//import com.koossery.workflow.credit.data.ScanPaySlipData;
import com.koossery.workflow.credit.data.ScanPaySlipData;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;
import com.koossery.workflow.credit.util.KTCreditRecordUtil;

import com.koossery.workflow.credit.data.ScanTaxSlipData;

public class CreditFormBackingBean extends BaseDialogBean {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static Log logger = LogFactory.getLog(CreditFormBackingBean.class);
	
	/* -------------- Alfresco services ------------------ */
	private ContentService contentService;
	private ServiceRegistry serviceRegistry;
	private transient NodeService nodeService;

	CustomManageTaskDialog customManageTaskDialog = (CustomManageTaskDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
	
	/** The NavigationBean bean reference */
	protected NavigationBean navigator;
	BrowseBean browseBean;
	// The DictionaryService bean reference */
	protected DictionaryService dictionaryService;
	FileFolderService fileFolderService;

	private boolean update = false;
	private boolean readOnly=false;
	
	CreditRecordData creditRecordData = null;
	ScanContratData scanContratData=null;
	ScanPaySlipData scanPaySlipData=null;
	ScanTaxSlipData scanTaxSlipData=null;
	GenerateContratData generateContratData=null;
 	/** The current space and it's properties - if any */
   	protected Node actionSpace;

   	/** The current document */
   	protected Node document;

     String outCome = "";
   	
   	/** Current node */

	/* --------------- data --------------- */ 
    
     
	
	
	private byte[] reportBytes;
	

	
	private static final String MSG_SAVE_CREDITRECORD_FAILED_SAVINGREPORT = "saveCreditRecord_err_failed";
	private static final String MSG_UPDATE_CREDITRECORD_FAILED_SAVINGREPORT = "udateCreditRecord_err_failed";
	private static final String MSG_SAVE_SCANPAYSLIP_FAILED = "saveScanPaySlip_err_failed";
	private static final String MSG_SAVE_SCANTAXSLIP_FAILED = "saveScanTaxSlip_err_failed";
	private static final String MSG_RETRIEVE_SCANPAYSLIP_FAILED = "retrieveScanPaySlip_err_failed";
	private static final String MSG_RETRIEVE_SCANTAXSLIP_FAILED = "retrieveScanTaxSlip_err_failed";

	private ClassPathResource CREDITRECORD_LOGO_PATH=new ClassPathResource(CreditConstant.ICON_CREDIT_RECORD);
      
    
    @Override
	public void init(Map<String, String> parameters) {
    	init();
		super.init(parameters);
		
		
				
	}

    
    public void init()
    {
		if(scanContratData==null)
		{
			scanContratData = new ScanContratData();
		}
		if(scanPaySlipData==null)
		{
			scanPaySlipData = new ScanPaySlipData();
		}
		if(scanTaxSlipData==null)
		{
			scanTaxSlipData = new ScanTaxSlipData();
		}
		if(generateContratData==null)
		{
			generateContratData = new GenerateContratData();
		}
		if(creditRecordData==null)
		{
			creditRecordData = new CreditRecordData();

			this.creditRecordData.setCivilitys(this.getPropertyConstraint(CreditRecordModel.PROP_CIVILITY));

			this.creditRecordData.setFamilySituations(this.getPropertyConstraint(CreditRecordModel.PROP_FAMILYSITUATION));
		
			this.creditRecordData.setLoanTypes(this.getPropertyConstraint(CreditRecordModel.PROP_LOANTYPE));

			this.creditRecordData.setDisbursementTypes(this.getPropertyConstraint(CreditRecordModel.PROP_DISBURSEMENTTYPE));
			
			this.creditRecordData.setCreditRecordRef(KTCreditRecordUtil.getDocumentId());
		}
		
    		
   	   if("".equals(this.outCome))
	 	 this.outCome= AlfrescoNavigationHandler.CLOSE_DIALOG_OUTCOME; 
	     System.out.println("Outcome CreditRecordBackingBean : "+this.outCome);
		
	     this.creditRecordData.setCreditModelRef(new NodeRef(Repository.getStoreRef(),CreditRecordModel.NAME.getLocalName()));
	     
    }
	protected String finishImpl(FacesContext arg0, String arg1) throws Throwable {
	    this.getCreditRecordData().checkNullFill(arg0);
		// TODO Auto-generated method stub
		customManageTaskDialog = (CustomManageTaskDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
		if(update==true)
		{
			this.update();
		}
		else{
		  this.save();			  
		  customManageTaskDialog.AddItemToPackageItemToAdd(this.creditRecordData.getCreditRecordNodeRef().toString());
		  customManageTaskDialog.updateResources();
		}
	
		return this.outCome;
	}
	
	
	public void initAdd(ActionEvent event){
		this.creditRecordData = new CreditRecordData();
		
		this.creditRecordData.setCivilitys(this.getPropertyConstraint(CreditRecordModel.PROP_CIVILITY));

		this.creditRecordData.setFamilySituations(this.getPropertyConstraint(CreditRecordModel.PROP_FAMILYSITUATION));
	
		this.creditRecordData.setLoanTypes(this.getPropertyConstraint(CreditRecordModel.PROP_LOANTYPE));

		this.creditRecordData.setDisbursementTypes(this.getPropertyConstraint(CreditRecordModel.PROP_DISBURSEMENTTYPE));
		
		this.creditRecordData.setCreditRecordRef(KTCreditRecordUtil.getDocumentId());
		
		scanContratData = new ScanContratData();
		scanPaySlipData = new ScanPaySlipData();
		scanTaxSlipData = new ScanTaxSlipData();
		generateContratData = new GenerateContratData();
		
		this.readOnly = false;
		this.update = false;
	
	}
		
	public void initView(ActionEvent event){
	      UIActionLink link = (UIActionLink)event.getComponent();
	      Map<String, String> params = link.getParameterMap();
	      customManageTaskDialog = (CustomManageTaskDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
	      System.out.println("public void initView(ActionEvent event){>>>>>>>>>>>>>>>>>>>< customManageTaskDialog = "+customManageTaskDialog);
	      String name = customManageTaskDialog.getCreditFormNodeId();
	      System.out.println("public void initView(ActionEvent event){>>>>>>>>>>>>>>>>>>>< id = "+name);
	      this.readOnly = true;
	      setupContent(name);
	      System.out.println("public void initView(ActionEvent event){>>>>>>>>>>>>>>>>>>>< id = "+name);
	}
	
	public void initUpdate(ActionEvent event){
	      UIActionLink link = (UIActionLink)event.getComponent();
	      Map<String, String> params = link.getParameterMap();
	      customManageTaskDialog = (CustomManageTaskDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
	      String name = customManageTaskDialog.getCreditFormNodeId();
	      this.readOnly = false;
	      setupContent(name);
	     
	}
	
	public void setupContent(String name)
	{
		init();
		this.update = true;

		try {
			// charger les donnes du  CreditRecord

			NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), name);			
		
			if(nodeService.exists(nodeRef)){
				
			    this.creditRecordData.setCreditRecordRef(name);
			 
				this.creditRecordData.setCreditRecordNodeRef(nodeRef);
				 
				this.creditRecordData.setCivility((String)nodeService.getProperty(nodeRef,CreditRecordModel.PROP_CIVILITY));
				
				this.creditRecordData.setName((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_NAME));
			
				this.creditRecordData.setSurname((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_SURNAME));
				
				this.creditRecordData.setBirthDate((Date)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_BIRTHDATE));
			
				this.creditRecordData.setCni((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_CNI));
				
				this.creditRecordData.setCountNumber(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_COUNTNUMBER).toString()));
				
				this.creditRecordData.setChildNumber(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_CHILDNUMBER).toString()));
		
				this.creditRecordData.setChildNumberInCharge(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_CHILDNUMBERINCHARGE).toString()));
				
				this.creditRecordData.setDisbursementType((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_DISBURSEMENTTYPE));
			
				this.creditRecordData.setEmail((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_EMAIL));
				
				this.creditRecordData.setFamilySituation((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_FAMILYSITUATION));
				
				this.creditRecordData.setLoanType((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_LOANTYPE));
				
				this.creditRecordData.setMonthlySalary(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_MONTHLYSALARY).toString()));
			
				this.creditRecordData.setProfessionnelSituation((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_PROFESSIONNELSITUATION));
			
				this.creditRecordData.setReimbursementDuration(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_REIMBURSEMENTDURATION).toString()));
				
				this.creditRecordData.setSince((Date)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_SINCE));
				
				this.creditRecordData.setStateDocument((String)nodeService.getProperty(nodeRef, CreditRecordModel.PROP_STATEDOCUMENT));
				
				this.creditRecordData.setBorrowAmount(Long.parseLong(nodeService.getProperty(nodeRef, CreditRecordModel.PROP_BORROWAMOUNT).toString()));
				
				List<AssociationRef> assocRefs = nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
				DictionaryService dd = Repository.getServiceRegistry(
			              FacesContext.getCurrentInstance()).getDictionaryService();
				//charger les pieces jointes
				/*if(assocRefs != null){						
					for (AssociationRef associationRef : assocRefs) {
						// Retrieve Photos
						if(dd.isSubClass(nodeService.getType(associationRef.getTargetRef()), CreditRecordModel.ASSOC_HASSCANPAYSLIP)){								
							retrieveScanPaySlip(associationRef);
						}	
						if(dd.isSubClass(nodeService.getType(associationRef.getTargetRef()), CreditRecordModel.ASSOC_HASSCANTAXSLIP)){								
							retrieveScanTaxSlip(associationRef);
						}	
					}
				}	*/

			}
			
		}catch (Throwable e) {
			logger.error(e.getMessage());
		}
	}
	
	/**
	 * enregistre un nouveau le creditrecord
	 */
	private void save(){
	
		UserTransaction tx = null;
		TransactionService transactionService = serviceRegistry.getTransactionService();
		FacesContext fc = FacesContext.getCurrentInstance();
		
		String mimeType;
		String objectType;
		String encoding;
	

		try {
			tx = transactionService.getUserTransaction();
			tx.begin();

		
			Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();

			String nodeName = this.creditRecordData.getCreditRecordRef();
			nodeProperties.put(ContentModel.PROP_NAME, nodeName);
			nodeProperties.put(ContentModel.PROP_DESCRIPTION, this.creditRecordData.getName());

			// Credit Records Properties
			nodeProperties.put(CreditRecordModel.PROP_NAME, this.creditRecordData.getName());
			nodeProperties.put(CreditRecordModel.PROP_BIRTHDATE, this.creditRecordData.getBirthDate());
			nodeProperties.put(CreditRecordModel.PROP_BORROWAMOUNT, this.creditRecordData.getBorrowAmount());
			nodeProperties.put(CreditRecordModel.PROP_CHILDNUMBER, this.creditRecordData.getChildNumber());
			nodeProperties.put(CreditRecordModel.PROP_CHILDNUMBERINCHARGE, this.creditRecordData.getChildNumberInCharge());
			nodeProperties.put(CreditRecordModel.PROP_CIVILITY,this.creditRecordData.getCivility());
			nodeProperties.put(CreditRecordModel.PROP_CNI, this.creditRecordData.getCni());
			nodeProperties.put(CreditRecordModel.PROP_COUNTNUMBER, this.creditRecordData.getCountNumber());
			nodeProperties.put(CreditRecordModel.PROP_DISBURSEMENTTYPE,this.creditRecordData.getDisbursementType());
			nodeProperties.put(CreditRecordModel.PROP_EMAIL,this.creditRecordData.getEmail());
			nodeProperties.put(CreditRecordModel.PROP_FAMILYSITUATION, this.creditRecordData.getFamilySituation());
			nodeProperties.put(CreditRecordModel.PROP_LOANTYPE,this.creditRecordData.getLoanType());
			nodeProperties.put(CreditRecordModel.PROP_MONTHLYSALARY,this.creditRecordData.getMonthlySalary());
			nodeProperties.put(CreditRecordModel.PROP_PROFESSIONNELSITUATION,this.creditRecordData.getProfessionnelSituation());
			nodeProperties.put(CreditRecordModel.PROP_REIMBURSEMENTDURATION,this.creditRecordData.getReimbursementDuration());
			nodeProperties.put(CreditRecordModel.PROP_SINCE,this.creditRecordData.getSince());
			nodeProperties.put(CreditRecordModel.PROP_STATEDOCUMENT,this.creditRecordData.getStateDocument());
			nodeProperties.put(CreditRecordModel.PROP_SURNAME,this.creditRecordData.getSurname());
			
			

			mimeType = Repository.getMimeTypeForFileName(fc, nodeName);
			encoding = "UTF-8";
			
			objectType = CreditRecordModel.TYPE_CREDITRECORD.toString();
			
			this.creditRecordData.setCreditRecordIcon(this.CREDITRECORD_LOGO_PATH.getInputStream());
			FileInfo fileInfo = this.fileFolderService.create(
					KTCreditRecordUtil.getCurrentContainerNodeRef(),
			        this.creditRecordData.getCreditRecordRef(),
		            Repository.resolveToQName(objectType));
			
			this.creditRecordData.setCreditRecordNodeRef(fileInfo.getNodeRef());
			
			InputStream is =null;							
			try{
				is = new BufferedInputStream(this.CREDITRECORD_LOGO_PATH.getInputStream());
				encoding = Repository.guessEncoding(fc, is, mimeType);
				
			}catch (Throwable e){
				  logger.error("Failed to get encoding", e);
				  e.printStackTrace();
			}finally{
				try { is.close(); } catch (Throwable e) {} 
			}
			
			// Fill in properties
			nodeService.setProperties(this.creditRecordData.getCreditRecordNodeRef(), nodeProperties);
		    // set the auditable aspect
		    Map<QName, Serializable> auditableProps = new HashMap<QName, Serializable>();
		    Date now = new Date();
		    String author = getServiceRegistry().getAuthenticationService().getCurrentUserName();
		    auditableProps.put(ContentModel.PROP_CREATOR, author);
		    auditableProps.put(ContentModel.PROP_MODIFIER, author);
		    auditableProps.put(ContentModel.PROP_CREATED, now);
		    auditableProps.put(ContentModel.PROP_MODIFIED, now);

		    this.nodeService.addAspect(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.ASPECT_AUDITABLE, auditableProps);

		    // set the versionable aspect
		    Map<QName, Serializable> versionableProps = new HashMap<QName, Serializable>();

		    versionableProps.put(ContentModel.PROP_AUTO_VERSION, true);
		    versionableProps.put(ContentModel.PROP_INITIAL_VERSION, true);

	
		
		    
		    this.nodeService.addAspect(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.ASPECT_VERSIONABLE, versionableProps);
		    
		    // set the author aspect
		    Map<QName, Serializable> authorProps = new HashMap<QName, Serializable>(1, 1.0f);
		    authorProps.put(ContentModel.PROP_AUTHOR, author);
		    this.nodeService.addAspect(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.ASPECT_AUTHOR, authorProps);


			// get a writer for the content and put the file
		    ContentWriter writer = getContentService().getWriter(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.TYPE_CONTENT, true);
		    // set the mimetype and encoding
		    writer.setMimetype(mimeType);
		    writer.setEncoding(encoding);
		    
		    writer.putContent(this.creditRecordData.getCreditRecordIcon());
			 
		  //  saveScanPaySlip();
		    //saveScanTaxSlip();

			tx.commit();
			
			
		} catch (Exception e) {
			
			logger.info(MSG_SAVE_CREDITRECORD_FAILED_SAVINGREPORT + e.toString());
			e.printStackTrace();
		

	}}

	
   /**
    * enregistrer les modification du creditrecord
    */
	public void update(){

		UserTransaction tx = null;
		TransactionService transactionService = serviceRegistry.getTransactionService();
		FacesContext fc = FacesContext.getCurrentInstance();
		
		String mimeType;
		String encoding;
		
		try {
			tx = transactionService.getUserTransaction();
			tx.begin();

			String nodeName = (String)nodeService.getProperty(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.PROP_NAME);

			// Update Product Properties
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),ContentModel.PROP_DESCRIPTION, this.creditRecordData.getName());

			// Credit Records Properties
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_NAME, this.creditRecordData.getName());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_BIRTHDATE, this.creditRecordData.getBirthDate());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_BORROWAMOUNT, this.creditRecordData.getBorrowAmount());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_CHILDNUMBER, this.creditRecordData.getChildNumber());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_CHILDNUMBERINCHARGE, this.creditRecordData.getChildNumberInCharge());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_CIVILITY,this.creditRecordData.getCivility());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_CNI, this.creditRecordData.getCni());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_COUNTNUMBER, this.creditRecordData.getCountNumber());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_DISBURSEMENTTYPE,this.creditRecordData.getDisbursementType());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_EMAIL,this.creditRecordData.getEmail());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_FAMILYSITUATION, this.creditRecordData.getFamilySituation());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_LOANTYPE,this.creditRecordData.getLoanType());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_MONTHLYSALARY,this.creditRecordData.getMonthlySalary());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_PROFESSIONNELSITUATION,this.creditRecordData.getProfessionnelSituation());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_REIMBURSEMENTDURATION,this.creditRecordData.getReimbursementDuration());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_SINCE,this.creditRecordData.getSince());
			//nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_STATEDOCUMENT,this.creditRecordData.getStateDocument());
			nodeService.setProperty(this.creditRecordData.getCreditRecordNodeRef(),CreditRecordModel.PROP_SURNAME,this.creditRecordData.getSurname());
		

			mimeType = Repository.getMimeTypeForFileName(fc, nodeName);
			encoding = "UTF-8";
			
			this.creditRecordData.setCreditRecordIcon(this.CREDITRECORD_LOGO_PATH.getInputStream());
			
			InputStream is =null;							
			try{
				is = new BufferedInputStream(this.CREDITRECORD_LOGO_PATH.getInputStream());
				encoding = Repository.guessEncoding(fc, is, mimeType);
				
			}catch (Throwable e){
				  logger.error("Failed to get encoding", e);
			}finally{
				try { is.close(); } catch (Throwable e) {} 
			}

		
			
		
			
		    // set the auditable aspect
		    Map<QName, Serializable> auditableProps = new HashMap<QName, Serializable>();
		    Date now = new Date();
		    String currentUser = getServiceRegistry().getAuthenticationService().getCurrentUserName();
		    auditableProps.put(ContentModel.PROP_CREATOR, (String)nodeService.getProperty(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.PROP_CREATOR));
		    auditableProps.put(ContentModel.PROP_MODIFIER, currentUser);
		    auditableProps.put(ContentModel.PROP_CREATED, (Date)nodeService.getProperty(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.PROP_CREATED));
		    auditableProps.put(ContentModel.PROP_MODIFIED, now);

		    this.nodeService.addAspect(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.ASPECT_AUDITABLE, auditableProps);
		    
			// get a writer for the content and put the file
		    ContentWriter writer = getContentService().getWriter(this.creditRecordData.getCreditRecordNodeRef(), ContentModel.TYPE_CONTENT, true);
		    // set the mimetype and encoding
		    writer.setMimetype(mimeType);
		    writer.setEncoding(encoding);
		    
		    writer.putContent(this.creditRecordData.getCreditRecordIcon());
		    
			tx.commit();
			
		} catch (Throwable e) {
			logger.info(MSG_UPDATE_CREDITRECORD_FAILED_SAVINGREPORT + e.toString());
					}


	}
	

	
   
    
   
	
	public boolean getFinishButtonDisabled() {
	return false;
	}
	
	
	
	
	public SelectItem[] getPropertyConstraint(QName PropertyName)
	{
	   
		ConstraintDefinition constDef = dictionaryService.getProperty(PropertyName).getConstraints().get(0);
	      
	  
	    ListOfValuesConstraint parameter =(ListOfValuesConstraint)constDef.getConstraint();
	   int i = 0;
	   SelectItem[] selectItem = new SelectItem[parameter.getAllowedValues().size()];
	    for (String iterator1: parameter.getAllowedValues()) {
	    	selectItem[i]= new SelectItem(iterator1);
			i++;
		}
	  
			return selectItem;
			
	}
   
   
	public ContentService getContentService() {
		return contentService;
	}
	public void setContentService(ContentService contentService) {
		this.contentService = contentService;
	}
	public ServiceRegistry getServiceRegistry() {
		return serviceRegistry;
	}
	public void setServiceRegistry(ServiceRegistry serviceRegistry) {
		this.serviceRegistry = serviceRegistry;
	}
	

        
	
	
	public NodeService getNodeService() {
		return nodeService;
	}

	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}

	public NavigationBean getNavigator() {
		return navigator;
	}

	public void setNavigator(NavigationBean navigator) {
		this.navigator = navigator;
	}

	public DictionaryService getDictionaryService() {
		return dictionaryService;
	}

	public void setDictionaryService(DictionaryService dictionaryService) {
		this.dictionaryService = dictionaryService;
	}

	

	public ScanContratData getScanContratData() {
		if(scanContratData==null)
		{
			scanContratData = new ScanContratData();
		}
		return scanContratData;
	}

	public void setScanContratData(ScanContratData scanContratData) {
		this.scanContratData = scanContratData;
	}

	public ScanPaySlipData getScanPaySlipData() {
		if(scanPaySlipData==null)
		{
			scanPaySlipData = new ScanPaySlipData();
		}
		return scanPaySlipData;
	}

	public void setScanPaySlipData(ScanPaySlipData scanPaySlipData) {
		this.scanPaySlipData = scanPaySlipData;
	}

	public ScanTaxSlipData getScanTaxSlipData() {
		if(scanTaxSlipData==null)
		{
			scanTaxSlipData = new ScanTaxSlipData();
		}
		return scanTaxSlipData;
	}

	public void setScanTaxSlipData(ScanTaxSlipData scanTaxSlipData) {
		this.scanTaxSlipData = scanTaxSlipData;
	}

	public GenerateContratData getGenerateContratData() {
		if(generateContratData==null)
		{
			generateContratData = new GenerateContratData();
		}
		return generateContratData;
	}

	public void setGenerateContratData(GenerateContratData generateContratData) {
		this.generateContratData = generateContratData;
	}

	public BrowseBean getBrowseBean() {
		return browseBean;
	}

	public void setBrowseBean(BrowseBean browseBean) {
		this.browseBean = browseBean;
	}

	

	public FileFolderService getFileFolderService() {
		return fileFolderService;
	}

	public void setFileFolderService(FileFolderService fileFolderService) {
		this.fileFolderService = fileFolderService;
	}

	public String getOutCome() {
		return outCome;
	}

	public void setOutCome(String outCome) {
		this.outCome = outCome;
	}

	public CustomManageTaskDialog getCustomManageTaskDialog() {
		return customManageTaskDialog;
	}

	public void setCustomManageTaskDialog(
			CustomManageTaskDialog customManageTaskDialog) {
		this.customManageTaskDialog = customManageTaskDialog;
	}

		  
	public CreditRecordData getCreditRecordData() {
		return creditRecordData;
	}

	public void setCreditRecordData(CreditRecordData creditRecordData) {
		this.creditRecordData = creditRecordData;
	}


	public boolean isReadOnly() {
		return readOnly;
	}


	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}
	
	
	

}
