package com.koossery.workflow.credit.backingbean.login;

import java.util.Date;


import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.web.bean.LoginBean;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.alfresco.service.ServiceRegistry;

import com.koossery.workflow.credit.util.CreditConstant;

import java.util.Set;

public class LoginBackingBean extends LoginBean  {
	  /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private ServiceRegistry serviceRegistry;
	private boolean isConseillerGroup;
	private static final Log logger = LogFactory.getLog(LoginBackingBean.class);


	   public String login()
	   {
		  
	      String outcome = super.login();
	      // log to the console who logged in and when
	      logger.info(getUsername() + " has logged in at " + new Date());
	      return outcome;
	   }

	
	   public String logout()
	   {
	      String outcome = super.logout();
	      // log to the console who logged out and when
	      logger.info(getUsername() + " logged out at " + new Date());
	      
	      return outcome;
	   }
	   
	   public boolean getIsConseillerGroup(){
		   
			Set<String> valuesGroup = AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<Set<String>>() {
				   public Set<String> doWork() throws Exception {
				      return serviceRegistry.getAuthorityService().getAuthoritiesForUser(getUsername());
				   }
				}, CreditConstant.USER_ADMIN);
		   
			for (String valueGroup : valuesGroup) {				
				if (valueGroup.equals(CreditConstant.GROUP_ADVISER_CLIENT)) {
					return true;
				} 				 
			}
		   return false;
	   }


	public ServiceRegistry getServiceRegistry() {
		return serviceRegistry;
	}


	public void setServiceRegistry(ServiceRegistry serviceRegistry) {
		this.serviceRegistry = serviceRegistry;
	}


	public void setConseillerGroup(boolean isConseillerGroup) {
		this.isConseillerGroup = isConseillerGroup;
	}
	}
