package com.koossery.workflow.credit.backingbean.managetask;
        


import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;

import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.AlfrescoNavigationHandler;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.TransientNode;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.workflow.ManageTaskDialog;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.alfresco.web.config.DialogsConfigElement.DialogButtonConfig;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;
import com.koossery.workflow.credit.util.KTCreditRecordUtil;

public class CustomManageTaskDialog extends ManageTaskDialog{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	transient private WorkflowService workflowService;
	private boolean ressourcesOk = true;
	private final static Log LOGGER = LogFactory.getLog(ManageTaskDialog.class);
	CreditFormBackingBean creditFormBackingBean;
	private String creditFormNode ="";
	private String generatedContrat ="";
	private boolean piecePayNotExist=true;
	private boolean pieceTaxNotExist=true;
	private boolean pieceScanContratNotExist=true;
	

	
	 public void init(Map<String, String> parameters)
	   {
		 super.init(parameters);
		 
		 System.out.println("parameters.get(id) : "+parameters.get("id"));
		 System.out.println("getWorkflowTask : "+this.getWorkflowTask());
		 
		 creditFormNode="";
		 pieceTaxNotExist=true;
		 piecePayNotExist=true;
		 pieceScanContratNotExist=true;
		 if(packageItemsToAdd!=null)
		 {
				 if(this.packageItemsToAdd.contains(creditFormBackingBean.getCreditRecordData().getCreditRecordNodeRef().toString()))
				 {
					 this.ressourcesOk=false;
					 
					
				 }
				 else
				 {
					 this.ressourcesOk=true; 
				 }
		 } 
		 else
		 {
			 this.ressourcesOk=true; 
		 }
	
	   }
	 
	 
	   public void removePackageItem(String nodeRef)
	   {
	     
	      System.out.println("CustomManageTaskDialog.removePackageItem => nodeRef= "+nodeRef);
	      if (this.packageItemsToAdd != null && this.packageItemsToAdd.contains(nodeRef))
	      {
	         // remove the item from the added list if it was added in this dialog session
	         this.packageItemsToAdd.remove(nodeRef);
	         
	         if (LOGGER.isDebugEnabled())
	            LOGGER.debug("Removed item from the added list: " + nodeRef); 
	           System.out.println("Removed item from the added list: " + nodeRef);
	      }
	      else
	      {
	         // add the node to the list of items to remove
	         if (this.packageItemsToRemove == null)
	         {
	            this.packageItemsToRemove = new ArrayList<String>(1);
	         }
	         
	         this.packageItemsToRemove.add(nodeRef);
	         
	         if (LOGGER.isDebugEnabled())
	            LOGGER.debug("Added item to the removed list: " + nodeRef);
	         System.out.println("Added item to the removed list: " + nodeRef);
	      }
	      
	      // reset the rich list so it re-renders
	      this.packageItemsRichList.setValue(null);
	    
	   }   	

	public CreditFormBackingBean getCreditFormBackingBean() {
		return creditFormBackingBean;
	}

	public void setCreditFormBackingBean(CreditFormBackingBean creditFormBackingBean) {
		this.creditFormBackingBean = creditFormBackingBean;
	}

	//Added by raph
	 
	 public String getFirstElementPackage(){
		 return this.creditFormNode;
	 }
	 
	 public String getWorkflowTaskName(){
		return this.getWorkflowTask().name;
	 }
	 
	 public String getCreditFormNodeId(){
		 int length = this.getFirstElementPackage().split("/").length;

		 String idCredit = this.getFirstElementPackage().split("/")[length-1];
		 
		 return idCredit;
	 } 
	 
	 public boolean isCreditFormTask(){
		 return this.getWorkflowTask().name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_CREDITFORM);
	 }
	 
	 public boolean isResultSimulationTask(){
		 return this.getWorkflowTask().name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_RESULTSIMULATION);
	 }	 
	 

	 public boolean isApprovalMemberTask(){
		 return this.getWorkflowTask().name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_APPROVALMEMBER);
	 }	 
	 
	 public boolean isCreditContractTask(){
		 return this.getWorkflowTask().name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_CREDITCONTRAT);
	 }
	 
	//End Added by raph
	public boolean isRessourcesOk() {
		return ressourcesOk;
	}
	
	public String getCredit(String id)
	{
		
		return (String)this.taskNode.getProperties().get(id);
	}
	
	public void AddItemToPackageItemToAdd(String item)
    {
		if(this.itemsToAdd==null)
		{
			System.out.println("RAPH AddItemToPackageItemToAdd >>>>>>>>>>>>>>>>>>> if(this.itemsToAdd==null) "); 
			this.itemsToAdd =new String[1];
		}
		
         this.itemsToAdd[0]= item;
  //       this.CreditRodeRef = item;
         System.out.println("RAPH AddItemToPackageItemToAdd >>>>>>>>>>>>>>>>>>> itemsToAdd.length: "+item +"; SIZE: "+itemsToAdd.length); 
         this.addPackageItems(null);
         System.out.println("RAPH AddItemToPackageItemToAdd >>>>>>>>>>>>>>>>>>> this.addPackageItems(null);: "+this.packageItemsToAdd.size());
    }
	
	   /**
	    * Adds an item to the workflow package
	    * 
	    * @param event The event
	    */
		@Override
	   public void addPackageItems(ActionEvent event)
	   {
			System.out.println("RAPH addPackageItems >>>>>>>>>>>>>>>>>>> this.itemsToAdd : "+this.itemsToAdd);
	      if (this.itemsToAdd != null)
	      {
	    	 System.out.println("RAPH addPackageItems >>>>>>>>>>>>>>>>>>>  if (this.itemsToAdd != null) ");
	         if (this.packageItemsToAdd == null)
	         {
	            // create the list of items to add if necessary
	            this.packageItemsToAdd = new ArrayList<String>(this.itemsToAdd.length);
	         }
	         
	         for (String item : this.itemsToAdd)
	         {
	            // if this item is in the remove list it means it was there originally
	            // and has now been re-added, as a result we don't need to do anything
	            // to the original workflow package, therefore remove from the remove list
	            if (this.packageItemsToRemove != null && this.packageItemsToRemove.contains(item))
	            {
	               this.packageItemsToRemove.remove(item);
	               
	               if (LOGGER.isDebugEnabled())
	                  LOGGER.debug("Removed item from the removed list: " + item);
	            }
	            else
	            {
	            	System.out.println("RAPH addPackageItems >>>>>>>>>>>>>>>>>>>  this.packageItemsToAdd.add(item); "+item);
	               this.packageItemsToAdd.add(item);
	               
	               if (LOGGER.isDebugEnabled())
	                  LOGGER.debug("Added item to the added list: " + item);
	            }
	         }
	         
	         // reset the rich list so it re-renders
	         this.packageItemsRichList.setValue(null);
	      }
	      
	      this.isItemBeingAdded = false;
	      this.itemsToAdd = null;
	   }
	
	@Override
    public void updateResources()
    {
    	
    	 // remove any items the user selected to remove 
        if (this.workflowPackage != null && this.packageItemsToRemove != null && 
            this.packageItemsToRemove.size() > 0)
        {
           for (String removedItem : this.packageItemsToRemove)
           {
              this.getNodeService().removeChild(this.workflowPackage, new NodeRef(removedItem));
           }
        }
        
        // add any items the user selected to add 
        if (this.workflowPackage != null && this.packageItemsToAdd != null && 
            this.packageItemsToAdd.size() > 0)
        {
        	System.out.println("packageItemsToAdd.size() : "+packageItemsToAdd.size());
           for (String addedItem : this.packageItemsToAdd)
           {
        	   System.out.println("addedItem : "+addedItem);
              NodeRef addedNodeRef = new NodeRef(addedItem);
              this.getNodeService().addChild(this.workflowPackage, addedNodeRef, 
                    ContentModel.ASSOC_CONTAINS, QName.createQName(NamespaceService.CONTENT_MODEL_1_0_URI,
                    QName.createValidLocalName((String)this.getNodeService().getProperty(
                          addedNodeRef, ContentModel.PROP_NAME))));
           }
        }
        
        this.packageItemsToAdd = null;
        this.packageItemsToRemove = null;
    	System.out.println("workflowPackage  : "+this.workflowPackage);
    }
	
	public void setRessourcesOk(boolean ressourcesOk) {
		this.ressourcesOk = ressourcesOk;
	}
	
	
	   
	   protected void createAndAddNode(NodeRef nodeRef)
	   {
	      // create our Node representation
		  System.out.println(nodeRef);
		  
	      MapNode node = new MapNode(nodeRef, this.getNodeService(), true);
	      this.browseBean.setupCommonBindingProperties(node);
	      
	      // add property resolvers to show path information
	      node.addPropertyResolver("path", this.browseBean.resolverPath);
	      node.addPropertyResolver("displayPath", this.browseBean.resolverDisplayPath);
	      //node.addPropertyResolver("credit", this.packageItemsToAdd.get(0));
	      // add a property resolver to indicate whether the item has been completed or not
//	      node.addPropertyResolver("completed", this.completeResolver);
	      
	      // add the id of the task being managed
	      node.getProperties().put("taskId", this.getWorkflowTask().id);
	
	    //  System.out.println("properties credit "+ packageItemsToAdd.indexOf(0));
	      //node.getProperties().put("credit", this.packageItemsToAdd.indexOf(0));
	    
	      this.resources.add(node);
	   }
	   
	   public List<Node> getResources()
	   {
		     pieceTaxNotExist=true;
			 piecePayNotExist=true;
			 ressourcesOk = true;
			 pieceScanContratNotExist=true;
		   System.out.println("public List<Node> getResources()>>>>>>>>>>>>>>>>>>>>>>> this.getWorkflowTask().name"+this.getWorkflowTask().name);
	      this.resources = new ArrayList<Node>(4);      
	      
	      if (this.workflowPackage != null)
	      {
	    	  System.out.println("RAPH>>>>>>>>>>>>>>>>>>>>>>> if (this.workflowPackage != null) ");
	         UserTransaction tx = null;
	         try
	         {
	            FacesContext context = FacesContext.getCurrentInstance();
	            tx = Repository.getUserTransaction(context, true);
	            tx.begin();

	            List<NodeRef> contents = this.workflowService.getPackageContents(getWorkflowTask().id);
	        	System.out.println("nodeRef : contents size => "+contents.size());
	            
	            for (NodeRef nodeRef : contents)
	            {	            	
	            	System.out.println("nodeRef : contents  => "+nodeRef);
	            	//this.creditFormNode = ""+nodeRef;
  	            	QName typeNodeRef = this.getNodeService().getType(nodeRef);
	            	if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_CREDITRECORD)){
	            		this.creditFormNode = ""+nodeRef;
	            		
	            		ressourcesOk = false;
	            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
	            	}	           	
	            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANTAXSLIP)){
	            		
	            		pieceTaxNotExist = false;
	            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
	            	}	
	            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANPAYSLIP)){
	            		
	            		piecePayNotExist = false;
	            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
	            	}
	            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANCONTRAT)){
	            		
	            		this.pieceScanContratNotExist = false;
	            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
	            	}	            	
	            		            	
	                if (nodeRef.getStoreRef().getProtocol().equals(StoreRef.PROTOCOL_AVM))
	                {
	                    Pair<Integer, String> vp = AVMNodeConverter.ToAVMVersionPath(nodeRef);
	                    this.addAVMNode(new AVMNode(this.getAvmService().lookup(vp.getFirst(),
	                            vp.getSecond(),
	                            true)));
	                }
	                else
	                {
	                	
	                    if (this.getNodeService().exists(nodeRef))
	                    {
	                  
	                        // find it's typrpe so we can see if it's a node we are interested in
	                        QName type = this.getNodeService().getType(nodeRef);

	                        // make sure the type is defined in the data dictionary
	                        if (this.getDictionaryService().getType(type) != null)
	                        {
	                       
	                            // look for content nodes or links to content
	                            // NOTE: folders within workflow packages are ignored for now
	                            if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT)||this.getDictionaryService().isSubClass(type, CreditRecordModel.TYPE_CREDITRECORD) || ApplicationModel.TYPE_FILELINK.equals(type))
	                            {
	                         
	                             // if the node is not in the removed list then add create the 
	                                // client side representation and add to the list
	                                if (this.packageItemsToRemove == null || 
	                                    this.packageItemsToRemove.contains(nodeRef.toString()) == false)
	                                {
	                              
	                                   createAndAddNode(nodeRef);
	                                }
	                            }
	                        }
	                    }
	                }
	            }
	            
	            System.out.println("AVANT RAPH if (this.packageItemsToAdd != null) >>>>>>>>>>>>>>>>>>>>>>> Entered  :packageItemsToAdd "+this.packageItemsToAdd);
	            // now iterate through the items to add list and add them to the list of resources
	            if (this.packageItemsToAdd != null)
	            {
	            	System.out.println("RAPH if (this.packageItemsToAdd != null) >>>>>>>>>>>>>>>>>>>>>>> Entered  :packageItemsToAdd "+this.packageItemsToAdd);
	               for (String newItem : this.packageItemsToAdd)
	               {
	            	   System.out.println("RAPH for (String newItem : this.packageItemsToAdd)>>>>>>>>>>>>>>>>>>>>>>> Entered  :packageItemsToAdd "+newItem);
	                  NodeRef nodeRef = new NodeRef(newItem);
	                  
	                  if (this.getNodeService().exists(nodeRef))
	                  {
	                     // we know the type is correct as this was added as a result of a query
	                     // for all content items so just add the item to the resources list
	                //	this.creditFormNode = newItem;
	                	 
	  	            	QName typeNodeRef = this.getNodeService().getType(nodeRef);
		            	if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_CREDITRECORD)){
		            		this.creditFormNode = newItem;

		            		ressourcesOk = false;
		            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
		            	}
		            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANTAXSLIP)){
		            		
		            		pieceTaxNotExist = false;
		            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
		            	}	
		            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANPAYSLIP)){
		            		
		            		piecePayNotExist = false;
		            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
		            	}	  
		            	else if(this.getDictionaryService().isSubClass(typeNodeRef, CreditRecordModel.TYPE_SCANCONTRAT)){
		            		
		            		this.pieceScanContratNotExist = false;
		            		System.out.println(" if(this.getDictionaryService().getType(CreditRecordModel.NAME).equals(typeNodeRef)){++++++> "+typeNodeRef.toString()+"===== NodeRef : "+creditFormNode);
		            	}			            	
	                     createAndAddNode(nodeRef);
	                  }
	                  else
	                  {
	                     if (LOGGER.isDebugEnabled())
	                        LOGGER.debug("Ignoring " + nodeRef + " as it has been removed from the repository");
	                  }
	               }
	            }
	            
	            // commit the transaction
	            tx.commit();
	         }
	         catch (Throwable err)
	         {
	    
	        	 
	            //Utils.addErrorMessage(MessageFormat.format(Application.getMessage(
	              //    FacesContext.getCurrentInstance(), Repository.ERROR_GENERIC), err.getMessage()), err);
	            this.resources = Collections.<Node>emptyList();
	            try { if (tx != null) {tx.rollback();} } catch (Exception tex) {}
	         }
	      }
	      else if (LOGGER.isDebugEnabled())
	      {
	         LOGGER.debug("Failed to find workflow package for task: " + this.getWorkflowTask().id);
	      }
	      
	      return this.resources;
	   }


	    @SuppressWarnings("deprecation")
	    @Override
	    public String transition()
	    {
	        String outcome = getDefaultFinishOutcome();    
	        
	        if (LOGGER.isDebugEnabled())
	            LOGGER.debug("Transitioning task: " + this.getWorkflowTask().id);

	        // before transitioning check the task still exists and is not completed
	        FacesContext context = FacesContext.getCurrentInstance();
	        WorkflowTask checkTask = this.getWorkflowService().getTaskById(this.getWorkflowTask().id);
	        if (checkTask == null || checkTask.state == WorkflowTaskState.COMPLETED)
	        {
	        	KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "invalid_task"));
	        	
	            return outcome;
	        }
	        
	        
	        // to find out which transition button was pressed we need
	        // to look for the button's id in the request parameters,
	        // the first non-null result is the button that was pressed.
	        Map<?, ?> reqParams = context.getExternalContext().getRequestParameterMap();

	        String selectedTransition = null;
	        for (WorkflowTransition trans : this.getWorkflowTransitions())
	        {
	            Object result = reqParams.get(CLIENT_ID_PREFIX + FacesHelper.makeLegalId(trans.title));
	            if (result != null)
	            {
	                // this was the button that was pressed
	                selectedTransition = trans.id;
	                break;
	            }
	        }

	        //Test si le formulaire est rempli
	        if(checkTask.name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_CREDITFORM) && this.isRessourcesOk()){
	            KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "error_credit_form_non_exist_simulation"));
	        	return "";
	        }
	        
	        //Nous testons si le nombre de pice est infrieur  2
	        else if(checkTask.name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_RESULTSIMULATION) &&  selectedTransition.equals(CreditConstant.WORKFLOW_CREDIT_TRANSITION_APPROVALCOMMITTE)){

	        	if(this.piecePayNotExist){
		            KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "error_add_piece_scan_pay_slip"));
	        		return "";
	        	}
	        	
	        	if(this.pieceTaxNotExist){
		            KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "error_add_piece_scan_tax"));
	        		return "";
	        	}	        	
	        	
	        }
	        
	        //Testons si le committe d'octroi de crdit ou le conseiller client veut achever un dossier de crdit dont le status est VERT
	        else if((checkTask.name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_APPROVALMEMBER) &&  selectedTransition.equals(CreditConstant.WORKFLOW_CREDIT_TRANSITION_APPROVALCOMMITTE_END))
	        		|| (checkTask.name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_RESULTSIMULATION) &&  selectedTransition.equals(CreditConstant.WORKFLOW_CREDIT_TRANSITION_RESULTSIMULATION_END))){
	       	        	
	        	if(KTCreditRecordUtil.simulationCreditRecord().equals(CreditConstant.CREDIT_FORM_STATE_DOCUMENT_GREEN)){
		            KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "error_not_end_process_document_green"));
	        		return "";	        		
	        	}
	        }
	        
	        //Nous Testons si le contrat scann  a t ajout      	        
	        else if(checkTask.name.equals(CreditConstant.WORKFLOW_CREDIT_TASK_CREDITCONTRAT) && selectedTransition.equals(CreditConstant.WORKFLOW_CREDIT_TRANSITION_ARCHIVING)){

	        	if(this.pieceScanContratNotExist){
		            KTCreditRecordUtil.addErrorMessage(Application.getMessage(context, "error_add_piece_scan_contrat"));
	        		return "";	        		
	        	}
	        		
	        }
	        	      
	        
	        UserTransaction tx = null;

	        try
	        {
	            tx = Repository.getUserTransaction(context);
	            tx.begin();

	            // prepare the edited parameters for saving
	            Map<QName, Serializable> params = WorkflowUtil.prepareTaskParams(this.taskNode);

	            if (LOGGER.isDebugEnabled())
	                LOGGER.debug("Transitioning task with parameters: " + params);

	            // update the task with the updated parameters and resources
	            updateResources();
	            this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);

	            // signal the selected transition to the workflow task
	            this.getWorkflowService().endTask(this.getWorkflowTask().id, selectedTransition);

	            // commit the changes
	            tx.commit();

	            if (LOGGER.isDebugEnabled())
	                LOGGER.debug("Ended task with transition: " + selectedTransition);
	        }
	        catch (Throwable e)
	        {
	            // rollback the transaction
	            try
	            {
	                if (tx != null)
	                {
	                    tx.rollback();
	                }
	            }
	            catch (Exception ex)
	            {
	            }
	            KTCreditRecordUtil.addErrorMessage(formatErrorMessage(e), e);
	            outcome = this.getErrorOutcome(e);
	        }

	        return outcome;
	    }
	    
	public WorkflowService getWorkflowService() {
		return workflowService;
	}


	public void setWorkflowService(WorkflowService workflowService) {
		this.workflowService = workflowService;
	}


	public boolean isPiecePayNotExist() {
		return piecePayNotExist;
	}


	public void setPiecePayNotExist(boolean isPiecePayNotExist) {
		this.piecePayNotExist = isPiecePayNotExist;
	}


	public boolean isPieceTaxNotExist() {
		
		return pieceTaxNotExist;
	}


	public void setPieceTaxNotExist(boolean isPieceTaxNotExist) {
		this.pieceTaxNotExist = isPieceTaxNotExist;
	}


	public boolean isPieceScanContratNotExist() {
		return pieceScanContratNotExist;
	}


	public void setPieceScanContratNotExist(boolean pieceScanContratNotExist) {
		this.pieceScanContratNotExist = pieceScanContratNotExist;
	}
}
