package com.koossery.workflow.credit.backingbean.piece;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;

import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.AlfrescoNavigationHandler;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.content.AddContentDialog;
import org.alfresco.web.ui.common.component.UIActionLink;

import com.koossery.workflow.credit.data.ContentCreditData;
import com.koossery.workflow.credit.data.GenerateContratData;
import com.koossery.workflow.credit.data.ScanContratData;
import com.koossery.workflow.credit.data.ScanPaySlipData;
import com.koossery.workflow.credit.data.ScanTaxSlipData;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;
import com.koossery.workflow.credit.util.KTCreditRecordUtil;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;

import org.alfresco.web.bean.repository.Repository;

public class PieceBackingBean extends AddContentDialog{

	/**
	 * 
	 */
	InputStream is = null;
	File myFile= null;
	private static final long serialVersionUID = 1L;
	boolean dialogControl = false;
	FileFolderService fileFolderService;
	CreditFormBackingBean creditFormBackingBean;
	NodeService nodeService;
	ServiceRegistry serviceRegistry;
	String id = "";
	private String action="add";
	private String piece;
	private SelectItem[]  pieces;
	public boolean etatPiece = false;
	private static final String MSG_SAVE_SCANPAYSLIP_FAILED = "saveScanPaySlip_err_failed";
	private static final String MSG_SAVE_SCANTAXSLIP_FAILED = "saveScanTaxSlip_err_failed";
	private static final String MSG_RETRIEVE_SCANPAYSLIP_FAILED = "retrieveScanPaySlip_err_failed";
	private static final String MSG_RETRIEVE_SCANTAXSLIP_FAILED = "retrieveScanTaxSlip_err_failed";
	private CustomManageTaskDialog manageTask = (CustomManageTaskDialog) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");


	
	public void initAdd(ActionEvent event){
	      UIActionLink link = (UIActionLink)event.getComponent();
	      Map<String, String> params = link.getParameterMap();
	      piece = params.get("piece");
		  System.out.println("initAdd ------------------------> piece: "+piece);
	      int length = manageTask.getFirstElementPackage().split("/").length;
		  id = manageTask.getFirstElementPackage().split("/")[length-1];	      
	      creditFormBackingBean.setupContent(id);
	      NodeRef creditFormNode = new NodeRef(Repository.getStoreRef(), id);
	      creditFormBackingBean.getCreditRecordData().setCreditRecordNodeRef(creditFormNode);
	     action="add";
	     etatPiece=false;
	     	     
	    // piece=CreditConstant.PIECE_PAYSLIP;
	     System.out.println("initAddPiece id : "+id);
	 
	}

	public void initRemove(ActionEvent event){
	      UIActionLink link = (UIActionLink)event.getComponent();
	      Map<String, String> params = link.getParameterMap();
	      piece = params.get("piece");
	      int length = manageTask.getFirstElementPackage().split("/").length;
		  id = manageTask.getFirstElementPackage().split("/")[length-1];	      
	      creditFormBackingBean.setupContent(id);
	      NodeRef creditFormNode = new NodeRef(Repository.getStoreRef(), id);
	      creditFormBackingBean.getCreditRecordData().setCreditRecordNodeRef(creditFormNode);
	     action = "remove";
	   // piece=CreditConstant.PIECE_PAYSLIP;
	     this.removeUploadedFile();
	}
	@Override
	protected String finishImpl(FacesContext arg0, String arg1)
			{
	//super.finishImpl(arg0, arg1);
		System.out.print("action : "+action+" piece : "+piece);
		if(action.equals("add"))
		{
		
			 if(piece.equals(CreditConstant.PIECE_PAYSLIP))
		      {
		    	  creditFormBackingBean.getScanPaySlipData().setContentCreditData(getCreditData(CreditRecordModel.TYPE_SCANPAYSLIP.toString()));
		    	  this.saveScanPaySlip();
		      }
		      else if(piece.equals(CreditConstant.PIECE_TAXSLIP)){
		    
		    	  creditFormBackingBean.getScanTaxSlipData().setContentCreditData(getCreditData(CreditRecordModel.TYPE_SCANTAXSLIP.toString()));
		          this.saveScanTaxSlip();
		      }
		      else if(piece.equals(CreditConstant.PIECE_SCAN_CONTRAT)){
		    	  creditFormBackingBean.getScanContratData().setContentCreditData(getCreditData(CreditRecordModel.TYPE_SCANCONTRAT.toString()));
		    	  this.saveScanContrat();
		      }
		}else 
		if(action.equals("update"))
		{
	
		} else
		 if(action.equals("remove"))
		 {
			 
		 }
		
		
		this.manageTask.updateResources();
		System.out.println("AlfrescoNavigationHandler.CLOSE_DIALOG_OUTCOME : "+AlfrescoNavigationHandler.CLOSE_DIALOG_OUTCOME);
	      
		return AlfrescoNavigationHandler.CLOSE_DIALOG_OUTCOME;
	
	}
	
	
	  private void saveScanPaySlip(){
		  
			try {
			  	 
				 System.out.println("filename : "+creditFormBackingBean.getScanPaySlipData().getName());
				 System.out.println("file : "+creditFormBackingBean.getScanPaySlipData().getFile());
				 System.out.println("getNodeRef : "+creditFormBackingBean.getScanPaySlipData().getNodeRef());

				  
				  
				  nodeService.setProperty(creditFormBackingBean.getScanPaySlipData().getNodeRef(), ContentModel.PROP_NAME, creditFormBackingBean.getScanPaySlipData().getName());
				  nodeService.setProperty(creditFormBackingBean.getScanPaySlipData().getNodeRef(), ContentModel.PROP_DESCRIPTION, "");
			    
				  // set the auditable aspect
				  Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
				  Date now = new Date();
				  String author = getServiceRegistry().getAuthenticationService().getCurrentUserName();
				  nodeProperties.put(ContentModel.PROP_CREATOR, creditFormBackingBean.getScanPaySlipData().getCreater());
				  nodeProperties.put(ContentModel.PROP_MODIFIER, creditFormBackingBean.getScanPaySlipData().getModifer() );
				  nodeProperties.put(ContentModel.PROP_CREATED, creditFormBackingBean.getScanPaySlipData().getCreated());
				  nodeProperties.put(ContentModel.PROP_MODIFIED, creditFormBackingBean.getScanPaySlipData().getModified());

				  this.nodeService.addAspect(creditFormBackingBean.getScanPaySlipData().getNodeRef(), ContentModel.ASPECT_AUDITABLE, nodeProperties);
			    
				  // set the author aspect
				  Map<QName, Serializable> authorProps = new HashMap<QName, Serializable>(1, 1.0f);
				  authorProps.put(ContentModel.PROP_AUTHOR, creditFormBackingBean.getScanPaySlipData().getCreater());
				  this.nodeService.addAspect(creditFormBackingBean.getScanPaySlipData().getNodeRef(), ContentModel.ASPECT_AUTHOR, authorProps);

				  // get a writer for the content and put the file
				  ContentWriter writer = getContentService().getWriter(creditFormBackingBean.getScanPaySlipData().getNodeRef(), ContentModel.PROP_CONTENT, true);
				  // set the mimetype and encoding
				  writer.setMimetype(creditFormBackingBean.getScanPaySlipData().getMineType());
				  writer.setEncoding(creditFormBackingBean.getScanPaySlipData().getEncoding());
			    
				  writer.putContent(creditFormBackingBean.getScanPaySlipData().getFile());
				
				  System.out.println("++++++++++++++++++++++++++++>>>>>>>< PAY createAssociation : "+creditFormBackingBean.getCreditRecordData().getCreditRecordRef());
				// Set association
			    nodeService.createAssociation(this.creditFormBackingBean.getCreditRecordData().getCreditRecordNodeRef(), this.creditFormBackingBean.getScanPaySlipData().getNodeRef(), CreditRecordModel.ASSOC_HASSCANPAYSLIP);
			    manageTask.AddItemToPackageItemToAdd(this.creditFormBackingBean.getScanPaySlipData().getNodeRef().toString());
			   // manageTask.updateResources();
			
			} catch (Throwable e) {
				e.printStackTrace();
	          logger.info(MSG_SAVE_SCANPAYSLIP_FAILED + e.toString());
	        } 
		}
	

	  private void saveScanTaxSlip(){
		  
			try {
			  	 
				 
				  
				  
				  nodeService.setProperty(creditFormBackingBean.getScanTaxSlipData().getNodeRef(), ContentModel.PROP_NAME, creditFormBackingBean.getScanTaxSlipData().getName());
				  nodeService.setProperty(creditFormBackingBean.getScanTaxSlipData().getNodeRef(), ContentModel.PROP_DESCRIPTION, "");
			    
				  // set the auditable aspect
				  Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
				  Date now = new Date();
				  String author = getServiceRegistry().getAuthenticationService().getCurrentUserName();
				  nodeProperties.put(ContentModel.PROP_CREATOR, creditFormBackingBean.getScanTaxSlipData().getCreater());
				  nodeProperties.put(ContentModel.PROP_MODIFIER, creditFormBackingBean.getScanTaxSlipData().getModifer() );
				  nodeProperties.put(ContentModel.PROP_CREATED, creditFormBackingBean.getScanTaxSlipData().getCreated());
				  nodeProperties.put(ContentModel.PROP_MODIFIED, creditFormBackingBean.getScanTaxSlipData().getModified());

				  this.nodeService.addAspect(creditFormBackingBean.getScanTaxSlipData().getNodeRef(), ContentModel.ASPECT_AUDITABLE, nodeProperties);
			    
				  // set the author aspect
				  Map<QName, Serializable> authorProps = new HashMap<QName, Serializable>(1, 1.0f);
				  authorProps.put(ContentModel.PROP_AUTHOR, creditFormBackingBean.getScanTaxSlipData().getCreater());
				  this.nodeService.addAspect(creditFormBackingBean.getScanTaxSlipData().getNodeRef(), ContentModel.ASPECT_AUTHOR, authorProps);

				  // get a writer for the content and put the file
				  ContentWriter writer = getContentService().getWriter(creditFormBackingBean.getScanTaxSlipData().getNodeRef(), ContentModel.PROP_CONTENT, true);
				  // set the mimetype and encoding
				  writer.setMimetype(creditFormBackingBean.getScanTaxSlipData().getMineType());
				  writer.setEncoding(creditFormBackingBean.getScanTaxSlipData().getEncoding());
			    
				  writer.putContent(creditFormBackingBean.getScanTaxSlipData().getFile());
				
				  System.out.println("++++++++++++++++++++++++++++>>>>>>>< TAX createAssociation : "+creditFormBackingBean.getCreditRecordData().getCreditRecordRef());
				// Set association
			    nodeService.createAssociation(this.creditFormBackingBean.getCreditRecordData().getCreditRecordNodeRef(), this.creditFormBackingBean.getScanTaxSlipData().getNodeRef(), CreditRecordModel.ASSOC_HASSCANTAXSLIP);
			    manageTask.AddItemToPackageItemToAdd(this.creditFormBackingBean.getScanTaxSlipData().getNodeRef().toString());
			    //manageTask.updateResources();

			} catch (Throwable e) {
				e.printStackTrace();
	          logger.info(MSG_SAVE_SCANTAXSLIP_FAILED + e.toString());
	        } 
		}
	    
	  private void saveScanContrat(){
		  
			try {
			  	 
				 System.out.println("filename : "+creditFormBackingBean.getScanContratData().getName());
				 System.out.println("file : "+creditFormBackingBean.getScanContratData().getFile());
				 System.out.println("getNodeRef : "+creditFormBackingBean.getScanContratData().getNodeRef());

				  
				  
				  nodeService.setProperty(creditFormBackingBean.getScanContratData().getNodeRef(), ContentModel.PROP_NAME, creditFormBackingBean.getScanContratData().getName());
				  nodeService.setProperty(creditFormBackingBean.getScanContratData().getNodeRef(), ContentModel.PROP_DESCRIPTION, "");
			    
				  // set the auditable aspect
				  Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
				  Date now = new Date();
				  String author = getServiceRegistry().getAuthenticationService().getCurrentUserName();
				  nodeProperties.put(ContentModel.PROP_CREATOR, creditFormBackingBean.getScanContratData().getCreater());
				  nodeProperties.put(ContentModel.PROP_MODIFIER, creditFormBackingBean.getScanContratData().getModifer() );
				  nodeProperties.put(ContentModel.PROP_CREATED, creditFormBackingBean.getScanContratData().getCreated());
				  nodeProperties.put(ContentModel.PROP_MODIFIED, creditFormBackingBean.getScanContratData().getModified());

				  this.nodeService.addAspect(creditFormBackingBean.getScanContratData().getNodeRef(), ContentModel.ASPECT_AUDITABLE, nodeProperties);
			    
				  // set the author aspect
				  Map<QName, Serializable> authorProps = new HashMap<QName, Serializable>(1, 1.0f);
				  authorProps.put(ContentModel.PROP_AUTHOR, creditFormBackingBean.getScanContratData().getCreater());
				  this.nodeService.addAspect(creditFormBackingBean.getScanContratData().getNodeRef(), ContentModel.ASPECT_AUTHOR, authorProps);

				  // get a writer for the content and put the file
				  ContentWriter writer = getContentService().getWriter(creditFormBackingBean.getScanContratData().getNodeRef(), ContentModel.PROP_CONTENT, true);
				  // set the mimetype and encoding
				  writer.setMimetype(creditFormBackingBean.getScanContratData().getMineType());
				  writer.setEncoding(creditFormBackingBean.getScanContratData().getEncoding());
			    
				  writer.putContent(creditFormBackingBean.getScanContratData().getFile());
				
				  System.out.println("++++++++++++++++++++++++++++>>>>>>>< SCAN createAssociation : "+creditFormBackingBean.getCreditRecordData().getCreditRecordRef());
				// Set association
			    nodeService.createAssociation(this.creditFormBackingBean.getCreditRecordData().getCreditRecordNodeRef(), this.creditFormBackingBean.getScanContratData().getNodeRef(), CreditRecordModel.ASSOC_HASSCANCONTRAT);
			    manageTask.AddItemToPackageItemToAdd(this.creditFormBackingBean.getScanContratData().getNodeRef().toString());
			   // manageTask.updateResources();
			
			} catch (Throwable e) {
				e.printStackTrace();
	          logger.info(MSG_SAVE_SCANPAYSLIP_FAILED + e.toString());
	        } 
		}	  
	    	
	
	public ContentCreditData getCreditData(String ObjectTypeA){
		FacesContext fc = FacesContext.getCurrentInstance();
		Date now = new Date();
		File dataFile = null;
		ContentCreditData contentCreditData = new ContentCreditData();

		contentCreditData.setAuthor(this.getAuthor());
		contentCreditData.setCreated(now);
		contentCreditData.setModified(now);
		contentCreditData.setModifer(this.author);
		contentCreditData.setCreater(this.author);
		contentCreditData.setDescription(this.getDescription());
		contentCreditData.setEncoding(this.getEncoding());
		
		contentCreditData.setMineType(this.getMimeType());
		contentCreditData.setName(this.getFileName());
		contentCreditData.setObjectType(ObjectTypeA);
		contentCreditData.setTitle(this.getFileName());
		String nodeName = ""+System.currentTimeMillis()+"_"+fileName;
		  
			FileInfo fileInfo = this.fileFolderService.create(
				 this.creditFormBackingBean.getCreditRecordData().getCreditRecordNodeRef(),
		          nodeName ,
		          Repository.resolveToQName(ObjectTypeA));

		  NodeRef fileNodeRef = fileInfo.getNodeRef();
		  
		contentCreditData.setNodeRef(fileNodeRef);
	
		//contentCreditData.setInputStream(is);
		
		contentCreditData.setFile(this.file);
		
		
		

		 
		FacesContext ctx = FacesContext.getCurrentInstance();
		  ctx.getExternalContext().getSessionMap().remove(FileUploadBean.FILE_UPLOAD_BEAN_NAME);
		  contentCreditData.nodeService=this.nodeService;
		  
		return contentCreditData;
	}
	public FileFolderService getFileFolderService() {
		return fileFolderService;
	}
	public void setFileFolderService(FileFolderService fileFolderService) {
		this.fileFolderService = fileFolderService;
	}
	public CreditFormBackingBean getCreditFormBackingBean() {
		return creditFormBackingBean;
	}
	public void setCreditFormBackingBean(CreditFormBackingBean creditFormBackingBean) {
		this.creditFormBackingBean = creditFormBackingBean;
	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public NodeService getNodeService() {
		return nodeService;
	}
	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}
	public ServiceRegistry getServiceRegistry() {
		return serviceRegistry;
	}
	public void setServiceRegistry(ServiceRegistry serviceRegistry) {
		this.serviceRegistry = serviceRegistry;
	}
	public String getPiece() {
		
		return CreditConstant.PIECE_PAYSLIP;
	}
	public void setPiece(String piece) {
		this.etatPiece=true;
		System.out.print("RAPH------------------------>setPiece : "+piece);
		this.piece = piece;
	}
	public SelectItem[] getPieces() {
		SelectItem[] selectItem = new SelectItem[2];
		selectItem[0]= new SelectItem(CreditConstant.PIECE_PAYSLIP);
		selectItem[1]= new SelectItem(CreditConstant.PIECE_TAXSLIP);
		pieces = selectItem;
		return selectItem;
	}
	public void setPieces(SelectItem[] pieces) {
		this.pieces = pieces;
	}
	
	
	  
	   /**
	    * @return Returns the name of the file
	    */
	   public String getFileName()
	   {
	      // try and retrieve the file and filename from the file upload bean
	      // representing the file we previously uploaded.
	      FacesContext ctx = FacesContext.getCurrentInstance();
	      FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().
	         get(FileUploadBean.FILE_UPLOAD_BEAN_NAME);
	      if (fileBean != null)
	      {
	         this.file = fileBean.getFile();
	         this.fileName = fileBean.getFileName();
	      }
	      System.out.println("this.file : " +this.file );
	      return this.fileName;
	   }

	   /**
	    * @param fileName The name of the file
	    */
	   public void setFileName(String fileName)
	   {
	      this.fileName = fileName;
	      
	      // we also need to keep the file upload bean in sync
	      FacesContext ctx = FacesContext.getCurrentInstance();
	      FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().
	         get(FileUploadBean.FILE_UPLOAD_BEAN_NAME);
	      if (fileBean != null)
	      {
	    	  System.out.println("file avant : "+fileBean.getFile());
	         fileBean.setFileName(this.fileName);
	        System.out.println("file apres : "+fileBean.getFile());
	      }
	   }
	   
	
}
