package com.koossery.workflow.credit.backingbean.space;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;

import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.web.app.AlfrescoNavigationHandler;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.content.DeleteContentDialog;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.spaces.DeleteSpaceDialog;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;

public class CustomDeleteSpaceDialog extends DeleteSpaceDialog{

	
	private static final long serialVersionUID = 5960844637376808571L;

	   private static final Log logger = LogFactory.getLog(DeleteContentDialog.class);
	   
	   private static final String DELETE_CREDITRECORD = "creditrecord";
	   private static final String DELETE_PAY = "pay";
	   private static final String DELETE_TAX = "tax";
	   private static final String DELETE_GENCONTRAT = "generate_contrat";
	   private static final String DELETE_SCANCONTRAT = "scan_contrat";
	   	   
		   
      String  name = "";
      ActionEvent actionEvent;
	   private List<String> deleteModes;
		
	  private CustomManageTaskDialog customManageTaskDialog  = (CustomManageTaskDialog)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
	   protected boolean hasMultipleParents = false;
       CreditFormBackingBean creditFormBackingBean = (CreditFormBackingBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "CreditFormBackingBean");
	   // ------------------------------------------------------------------------------
	   // Dialog implementation
	   
	   @Override
	   public void init(Map<String, String> parameters)
	   {
	      super.init(parameters);
	      
	      
	   }
	   
	   public void initRemove(ActionEvent event)
		{
			 UIActionLink link = (UIActionLink)event.getComponent();
		      Map<String, String> params = link.getParameterMap();
		       name = customManageTaskDialog.getCreditFormNodeId();
		       actionEvent = event;
		       creditFormBackingBean.setupContent(name);
			
		}
	  
	   
	   protected String finishImpl(FacesContext context, String outcome)
       throws Exception
 {
		   NodeRef nodeR = new NodeRef(Repository.getStoreRef(), name);
		   Node node = new Node(nodeR);
		   System.out.println("CustomDeleteSpaceDialog.delete => name = "+name);		   
			
		      if (node != null)
		      {
		         // force cache of name property so we can use it after the delete
		         node.getName();
		  	   System.out.println("CustomDeleteSpaceDialog.delete => DELETE_CREDITRECORD = "+DELETE_CREDITRECORD);
		  	   System.out.println("CustomDeleteSpaceDialog.delete => getDeleteModes().size() = "+getDeleteModes().size());
		  	   System.out.println("CustomDeleteSpaceDialog.delete => this.getDeleteModes().contains(DELETE_CREDITRECORD) = "+this.getDeleteModes().contains(DELETE_CREDITRECORD));
		  	 System.out.println("CustomDeleteSpaceDialog.delete => this.getDeleteModes().contains(DELETE_GENCONTRAT) = "+this.getDeleteModes().contains(DELETE_GENCONTRAT));
		  	 System.out.println("CustomDeleteSpaceDialog.delete => this.getDeleteModes().contains(DELETE_PAY) = "+this.getDeleteModes().contains(DELETE_PAY));
		  	 System.out.println("CustomDeleteSpaceDialog.delete => this.getDeleteModes().contains(DELETE_SCANCONTRAT) = "+this.getDeleteModes().contains(DELETE_SCANCONTRAT));
		  	 System.out.println("CustomDeleteSpaceDialog.delete => this.getDeleteModes().contains(DELETE_TAX) = "+this.getDeleteModes().contains(DELETE_TAX));
		       
		  	 if(this.getDeleteModes().size()>0)
		  	 {
		  		 for (String str : this.getDeleteModes()) {
					System.out.println("this.getDeleteModes() containt => "+str);
				}
		  	 }
		  	 
		  	
		         
		        	 List<NodeRef> deleteRefs = new ArrayList<NodeRef>(4);
		        	 List<AssociationRef> deleteAssocRefs = new ArrayList<AssociationRef>(4);
		
		        	 List<AssociationRef> assocRefs = this.getNodeService().getTargetAssocs(node.getNodeRef(), RegexQNamePattern.MATCH_ALL);
		        	System.out.println("assocRefs size"+assocRefs.size());
		        	
		        	
		        	
		        	 DictionaryService dd = Repository.getServiceRegistry(
				              FacesContext.getCurrentInstance()).getDictionaryService(); 
		        	 if (this.getDeleteModes().contains(DELETE_PAY))
	                 {
		        		 System.out.println("DELETE_PAY => "+DELETE_PAY);
		        	     for (AssociationRef associationRef : assocRefs) {
								// Retrieve Photos
		        	    	
							 
		        	    	 if(this.getDictionaryService().isSubClass(this.getNodeService().getType(associationRef.getTargetRef()), CreditRecordModel.TYPE_SCANPAYSLIP)){								
									System.out.println("associationRef.getTargetRef() => "+associationRef.getTargetRef());
					   	           
				                      deleteRefs.add(associationRef.getTargetRef());
				                      deleteAssocRefs.add(associationRef);
				                      //this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), CreditRecordModel.ASSOC_HASSCANPAYSLIP);
								}	
								
							}
					 }
		        	 if (this.getDeleteModes().contains(DELETE_TAX))
	                 {
		        		 System.out.println("DELETE_TAX => "+DELETE_TAX);
		        	     for (AssociationRef associationRef : assocRefs) {
								// Retrieve Photos
		        	    	 System.out.println("associationRef => "+associationRef);
		        			 if(this.getDictionaryService().isSubClass(this.getNodeService().getType(associationRef.getTargetRef()), CreditRecordModel.TYPE_SCANTAXSLIP)){							
									System.out.println("associationRef.getTargetRef() => "+associationRef.getTargetRef());
					   	            
				                      deleteRefs.add(associationRef.getTargetRef());
				                      deleteAssocRefs.add(associationRef);
				                      //this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), CreditRecordModel.ASSOC_HASSCANTAXSLIP);
								}	
								
							}
					 }
		        	 
		        	 if (this.getDeleteModes().contains(DELETE_SCANCONTRAT))
	                 {
		        		 System.out.println("DELETE_SCANCONTRAT => "+DELETE_SCANCONTRAT);
		        	     for (AssociationRef associationRef : assocRefs) {
								// Retrieve Photos
		        			 if(this.getDictionaryService().isSubClass(this.getNodeService().getType(associationRef.getTargetRef()), CreditRecordModel.TYPE_SCANCONTRAT)){							
									System.out.println("associationRef.getTargetRef() => "+associationRef.getTargetRef());
					   	           
				                      deleteRefs.add(associationRef.getTargetRef());
				                      deleteAssocRefs.add(associationRef);
				                      //this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), CreditRecordModel.ASSOC_HASSCANCONTRAT);
								}	
								
							}
					 }
		        	 if (this.getDeleteModes().contains(DELETE_GENCONTRAT))
	                 {
		        		 System.out.println("DELETE_GENCONTRAT => "+DELETE_GENCONTRAT);
		        	     for (AssociationRef associationRef : assocRefs) {
								// Retrieve Photos
		        			 if(this.getDictionaryService().isSubClass(this.getNodeService().getType(associationRef.getTargetRef()), CreditRecordModel.TYPE_GENERATECONTRAT)){						
									System.out.println("associationRef.getTargetRef() => "+associationRef.getTargetRef());
					   	           
				                      deleteRefs.add(associationRef.getTargetRef());
				                      deleteAssocRefs.add(associationRef);
				                      
				                      //this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), CreditRecordModel.ASSOC_GENERATECONTRACTASPECT);
								}	
								
							}
					 }
		        		 
		        		 
		        	
	                 
		            // delete the list of refs
		            TransactionService txService = Repository.getServiceRegistry(context).getTransactionService();
		            for (NodeRef nodeRef : deleteRefs)
		            {
		               UserTransaction tx = null;
		      
		               try
		               {
		                  tx = txService.getNonPropagatingUserTransaction();
		                  tx.begin();
		               	  System.out.println("nodeRef delete => "+nodeRef);
		               
		               	  
		               	  customManageTaskDialog.removePackageItem(nodeRef.toString());
		                  
		                  customManageTaskDialog.updateResources();
		                  
		                  if(this.getNodeService().exists(nodeRef))
		                  {
		                   this.getNodeService().deleteNode(nodeRef);
		                  }
		                  else{
		                	  System.out.println("nodeRef do not exist => "+nodeRef);
		                  }
		                  tx.commit();
		               }
		               catch (Throwable err)
		               {
		            	   err.printStackTrace();
		                  try { 
		                	  if (tx != null) {tx.rollback();
		                	  }
		                	  }
		                  catch (Exception ex) {
		                	  
		                	  ex.printStackTrace();
		                  }
		               }
		            }
		           
		            /*for (AssociationRef associationRef2 : deleteAssocRefs) {
		            	System.out.println("delete associationRef2 "+associationRef2);
		            	this.getNodeService().removeAssociation(associationRef2.getSourceRef(), associationRef2.getTargetRef(), associationRef2.getTypeQName());
              
					}*/
		        
		        	 if ( this.getDeleteModes().contains(DELETE_CREDITRECORD))
			         {
			            NodeRef nodeRef = node.getNodeRef();
			            if (this.getNodeService().exists(nodeRef))
			            {  
			            	try{
			            		for (AssociationRef associationRef : assocRefs) 
				               	{
				              	  customManageTaskDialog.removePackageItem(associationRef.getTargetRef().toString());
				               	}
			            		customManageTaskDialog.removePackageItem(node.getNodeRef().toString());
			            		customManageTaskDialog.updateResources();
				               if(this.getNodeService().exists(node.getNodeRef())){
				            	   this.getNodeService().deleteNode(node.getNodeRef());
				               }
				               else{
				            	   System.out.println("noderef do not exist => "+node.getNodeRef());
				               }
			            		
			                }catch (Exception e) {
								// TODO: handle exception
			                	e.printStackTrace();
							}
			               // The node still exists
	                        
			            }
			         }
		         
		     
		         
		      }
		      else
		      {
		         logger.warn("WARNING: delete called without a current Space!");
		      }
		      
		      
		      return outcome;
     }
	
	   
	   // ------------------------------------------------------------------------------
	   // Bean Getters and Setters
	   
	   /**
	    * Returns the confirmation to display to the user before deleting the content.
	    * 
	    * @return The formatted message to display
	    */
	   public String getConfirmMessage()
	   {
	      String fileConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), 
	               getConfirmMessageId());
	      
	      Node node = this.browseBean.getActionSpace();
	      if (node != null)
	      {
	         return MessageFormat.format(fileConfirmMsg, new Object[] {node.getName()});
	      }
	      else
	      {
	         return Application.getMessage(FacesContext.getCurrentInstance(), 
	                  "delete_node_not_found");
	      }
	   }
	   
	

	   /**
	    * @return true if the space has multiple parents
	    */
	   public boolean getHasMultipleParents()
	   {
	      return this.hasMultipleParents;
	   }



	public List<String> getDeleteModes() {
		return deleteModes;
	}



	public void setDeleteModes(List<String> deleteModes) {
		this.deleteModes = deleteModes;
	}

	public boolean isCreditCanDeleted() {

		return !customManageTaskDialog.isRessourcesOk() && customManageTaskDialog.isCreditFormTask();
	}   

	public boolean isPiecePayCanDeleted() {
		
		return !customManageTaskDialog.isPiecePayNotExist() && (customManageTaskDialog.isCreditFormTask() || customManageTaskDialog.isResultSimulationTask());
	}
	
	public boolean isPieceTaxCanDeleted() {
		
		return !customManageTaskDialog.isPieceTaxNotExist() && (customManageTaskDialog.isCreditFormTask() || customManageTaskDialog.isResultSimulationTask());
	}	
	
	public boolean isScanContratCanDeleted() {
		
		return !customManageTaskDialog.isPieceScanContratNotExist() && customManageTaskDialog.isCreditContractTask();
	}		
}
