package com.koossery.workflow.credit.data;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;

import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.repository.Node;

import com.koossery.workflow.credit.model.CreditRecordModel;

public class ContentCreditData implements Serializable{

	private static final long serialVersionUID = 2907286066016199827L;
	
	private NodeRef nodeRef;
	public NodeService nodeService;

	private String author;
	private String description;
	private String encoding;
	private InputStream inputStream;
	private String name;
	private String mineType;
	private String objectType;
	private String title;
	private File file;
	private Date created;
	private String creater;
	private String modifer;
	private Date modified;
	
  	/** The current browse view mode - set to a well known IRichListRenderer identifier */
   	private Node viewingNode = null;
   	
 
   	/**
   	 * cette mthode doit tre appelle  chaque fois qu'on  dsire afficher le content
   	 */
     public void prepareViewingNode() {
   
		
		if(viewingNode==null)
		{
			Node viewingNode1 = new Node(nodeRef);
			viewingNode1.getProperties().put(CreditRecordModel.CPROP_MIMETYPE.getLocalName(), mineType);
  		    viewingNode1.getProperties().put(CreditRecordModel.CPROP_ENCODING.getLocalName(), encoding);
 
  		    viewingNode=viewingNode1;
		}
	}
   	
   	public Node getViewingNode() {
   		
		return viewingNode;
	}
	public void setViewingNode(Node viewingNode) {
		
		
		this.viewingNode = viewingNode;
	}
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getEncoding() {
		return encoding;
	}
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}
	public InputStream getInputStream() {
		return inputStream;
	}
	public void setInputStream(InputStream inputStream) {
			
		this.inputStream = inputStream;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getMineType() {
		return mineType;
	}
	public void setMineType(String mineType) {
		this.mineType = mineType;
	}
	public String getObjectType() {
		return objectType;
	}
	public void setObjectType(String objectType) {
		this.objectType = objectType;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public Date getCreated() {
		return created;
	}
	public void setCreated(Date created) {
		this.created = created;
	}
	public String getCreater() {
		return creater;
	}
	public void setCreater(String creater) {
		this.creater = creater;
	}
	public String getModifer() {
		return modifer;
	}
	public void setModifer(String modifer) {
		this.modifer = modifer;
	}
	public Date getModified() {
		return modified;
	}
	public void setModified(Date modified) {
		this.modified = modified;
	}
	public NodeRef getNodeRef() {
		return nodeRef;
	}
	public void setNodeRef(NodeRef nodeRef) {
		this.nodeRef = nodeRef;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}
	
	
}
