package com.koossery.workflow.credit.data;


import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.regex.*;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;

import com.koossery.workflow.credit.util.CreditConstant;
public class CreditRecordData implements Serializable{

	private String civility;
	private SelectItem[] civilitys;
	private String name;
	private String surname;
	private Date birthDate;
	private String cni;
	private String familySituation;
	private SelectItem[] familySituations;
	private long childNumber;
	private long childNumberInCharge;
	private String email;
	private String professionnelSituation;
	private Date since;
	private long borrowAmount;
	private long reimbursementDuration;
	private long monthlySalary;
	private String loanType;
	private SelectItem[] loanTypes;
	private String disbursementType;
	private SelectItem[] disbursementTypes;
	private long countNumber; 
	private String stateDocument;
	
	String creditRecordRef;
	private NodeRef creditModelRef;
	private NodeRef creditRecordNodeRef;
	InputStream creditRecordIcon;
	public String getCivility() {
		return civility;
	}
	public void setCivility(String civility) {
		this.civility = civility;
	}
	public SelectItem[] getCivilitys() {
		return civilitys;
	}
	public void setCivilitys(SelectItem[] civilitys) {
		this.civilitys = civilitys;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getSurname() {
		return surname;
	}
	public void setSurname(String surname) {
		this.surname = surname;
	}
	public Date getBirthDate() {
		return birthDate;
	}
	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}
	public String getCni() {
		return cni;
	}
	public void setCni(String cni) {
		this.cni = cni;
	}
	public String getFamilySituation() {
		return familySituation;
	}
	public void setFamilySituation(String familySituation) {
		this.familySituation = familySituation;
	}
	public SelectItem[] getFamilySituations() {
		return familySituations;
	}
	public void setFamilySituations(SelectItem[] familySituations) {
		this.familySituations = familySituations;
	}
	public long getChildNumber() {
		return childNumber;
	}
	public void setChildNumber(long childNumber) {
		this.childNumber = childNumber;
	}
	public long getChildNumberInCharge() {
		return childNumberInCharge;
	}
	public void setChildNumberInCharge(long childNumberInCharge) {
		this.childNumberInCharge = childNumberInCharge;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getProfessionnelSituation() {
		return professionnelSituation;
	}
	public void setProfessionnelSituation(String professionnelSituation) {
		this.professionnelSituation = professionnelSituation;
	}
	public Date getSince() {
		return since;
	}
	public void setSince(Date since) {
		this.since = since;
	}
	public long getBorrowAmount() {
		return borrowAmount;
	}
	public void setBorrowAmount(long borrowAmount) {
		this.borrowAmount = borrowAmount;
	}
	public long getReimbursementDuration() {
		return reimbursementDuration;
	}
	public void setReimbursementDuration(long reimbursementDuration) {
		this.reimbursementDuration = reimbursementDuration;
	}
	public long getMonthlySalary() {
		return monthlySalary;
	}
	public void setMonthlySalary(long monthlySalary) {
		this.monthlySalary = monthlySalary;
	}
	public String getLoanType() {
		return loanType;
	}
	public void setLoanType(String loanType) {
		this.loanType = loanType;
	}
	public SelectItem[] getLoanTypes() {
		return loanTypes;
	}
	public void setLoanTypes(SelectItem[] loanTypes) {
		this.loanTypes = loanTypes;
	}
	public String getDisbursementType() {
		return disbursementType;
	}
	public void setDisbursementType(String disbursementType) {
		this.disbursementType = disbursementType;
	}
	public SelectItem[] getDisbursementTypes() {
		return disbursementTypes;
	}
	public void setDisbursementTypes(SelectItem[] disbursementTypes) {
		this.disbursementTypes = disbursementTypes;
	}
	public long getCountNumber() {
		return countNumber;
	}
	public void setCountNumber(long countNumber) {
		this.countNumber = countNumber;
	}
	public String getStateDocument() {
		return stateDocument;
	}
	public void setStateDocument(String stateDocument) {
		this.stateDocument = stateDocument;
	}
	public String getCreditRecordRef() {
		return creditRecordRef;
	}
	public void setCreditRecordRef(String creditRecordRef) {
		this.creditRecordRef = creditRecordRef;
	}
	public NodeRef getCreditModelRef() {
		return creditModelRef;
	}
	public void setCreditModelRef(NodeRef creditModelRef) {
		this.creditModelRef = creditModelRef;
	}
	public NodeRef getCreditRecordNodeRef() {
		return creditRecordNodeRef;
	}
	public void setCreditRecordNodeRef(NodeRef creditRecordNodeRef) {
		this.creditRecordNodeRef = creditRecordNodeRef;
	}
	public InputStream getCreditRecordIcon() {
		return creditRecordIcon;
	}
	public void setCreditRecordIcon(InputStream creditRecordIcon) {
		this.creditRecordIcon = creditRecordIcon;
	}
	 public void validateEmail (FacesContext context, UIComponent component, Object value)
	    throws ValidatorException{
		
		 String aEmailAddress = ((String)value).trim();
		  System.out.println("validateEmail aEmailAddress =>"+aEmailAddress );
		  
		 Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
             
	      //Match the given string with the pattern
	      Matcher m = p.matcher(aEmailAddress);

	      //check whether match is found 
	      boolean matchFound = m.matches();
		    if(matchFound==false || aEmailAddress==null || aEmailAddress.equals(""))
		    {
			    String err = MessageFormat.format(Application.getMessage(context, "\n "+CreditConstant.MSG_EMAIL),
				          new Object[]{"difson@henvino.com"});
				    throw new ValidatorException(new FacesMessage(err));
		    }
		 
		  }
	 
	  /**
	    * Validate Username field data is acceptable
	    */
	   public void validateString(FacesContext context, UIComponent component, Object value)
	         throws ValidatorException
	   {
	      int minUsernameLength = 1;
	      
	      String name = ((String)value).trim();
	      System.out.println("validateString name =>"+name );
	      if ((name.length() < minUsernameLength || name.length() > 256)|| name==null || name.equals(""))
	      {
	         String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_LENGTH),
	               new Object[]{minUsernameLength, 256});
	         throw new ValidatorException(new FacesMessage(err));
	      }
	      if (name.indexOf('"') != -1)
	      {
	         String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_ERR),
	               new Object[]{"\""});
	         throw new ValidatorException(new FacesMessage(err));
	      }
	   }
	   
	   public void checkNullFill(FacesContext context)
	   {
		   
		   if(this.name==null||this.name.equals("")){
			   
			   String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_NULL),
		               new Object[]{"name"});
		         throw new ValidatorException(new FacesMessage(err));
		   }
		   if(this.surname==null||this.surname.equals(""))
		   {
			   String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_NULL),
		               new Object[]{"surname"});
		         throw new ValidatorException(new FacesMessage(err)); 
		   }
		   if(this.cni==null||this.cni.equals(""))
		   {
			   String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_NULL),
		               new Object[]{"cni"});
		         throw new ValidatorException(new FacesMessage(err)); 
		   }
		   if(this.email==null||this.email.equals(""))
		   {
			   String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_NULL),
		               new Object[]{"email"});
		         throw new ValidatorException(new FacesMessage(err)); 
		   }
		   if(this.professionnelSituation==null||this.professionnelSituation.equals(""))
		   {
			   String err = MessageFormat.format(Application.getMessage(context, CreditConstant.MSG_STRING_NULL),
		               new Object[]{"professionnelSituation"});
		         throw new ValidatorException(new FacesMessage(err)); 
		   }
		   
	   }
	   


}
