package com.koossery.workflow.credit.handler.common;

/**
 * @author Raphael 
 */
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;

import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;

public class DocumentStateActionHandler implements ActionHandler {

	public void execute(ExecutionContext arg0) throws Exception {
		
		NodeService nodeService = (NodeService) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "NodeService");
		ServiceRegistry serviceRegistry = (ServiceRegistry) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ServiceRegistry");
		CreditFormBackingBean creditFormData = (CreditFormBackingBean) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "CreditFormBackingBean");
		CustomManageTaskDialog manageTask = (CustomManageTaskDialog) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
		
		UserTransaction tx = null;
		TransactionService transactionService = serviceRegistry.getTransactionService();
		
		//Credit Form
//		System.out.print("RAPH  ------------------------->>>>>>>>>>>>> manageTask.getFirstElementPackage(): "+manageTask.getFirstElementPackage());
		
		if(!manageTask.getFirstElementPackage().equals("")){
			int length = manageTask.getFirstElementPackage().split("/").length;
			String id = manageTask.getFirstElementPackage().split("/")[length-1];	
			
			creditFormData.setupContent(id);
			
			try {
				tx = transactionService.getUserTransaction();
				tx.begin();			
				
				nodeService.setProperty(creditFormData.getCreditRecordData().getCreditRecordNodeRef(),CreditRecordModel.PROP_STATEDOCUMENT,arg0.getNode().getName());
				
				tx.commit();
				System.out.print("------------------------->>>>>>>>>>>>> Enregistrement de PROP_STATEDOCUMENT : "+arg0.getNode().getName());
			} catch (Throwable e) {
				//logger.info(MSG_UPDATE_CREDITRECORD_FAILED_SAVINGREPORT + e.toString());
				e.printStackTrace();
			}
		}

	}
	
}
