package com.koossery.workflow.credit.handler.legalservice;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;

import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.workflow.ManageTaskDialog;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.core.io.ClassPathResource;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.login.LoginBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.data.GenerateContratData;
import com.koossery.workflow.credit.handler.common.DocumentStateActionHandler;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;
import com.koossery.workflow.credit.util.KTCreditRecordUtil;


/**
 * Gnre le contrat avec jasperreport et l'ajoute au node CreditRecord afin que le seervice juridique puisse l'ouvrir, le modifier puis l'enregistrer
 * @author Prosper_2
 * le contrat gnr est ajouter via un aspect.
 */

public class LegalServiceActionHandler extends DocumentStateActionHandler {
	//---LOGGER
	private Logger logger = Logger.getLogger(GenerateContratData.class.toString());
	
	/* --------------- JASPER REPORT FILE AND RESSOURCES  --------------- */ 
	private ClassPathResource JASPER_REPORT_CONTEXT_PATH=new ClassPathResource(CreditConstant.GENERATEDCONTRAT_JASPER_REPORT_CONTEXT_PATH);
	private ClassPathResource JRXML_REPORT_CONTEXT_PATH=new ClassPathResource(CreditConstant.GENERATEDCONTRAT_JRXML_REPORT_CONTEXT_PATH);
	private ClassPathResource JASPER_REPORT_KOOSSERY_LOGO_PATH=new ClassPathResource(CreditConstant.GENERATEDCONTRAT_JASPER_REPORT_KOOSSERY_LOGO_PATH);

	//-- Error messages
	private  final String MSG_PRODUCT_REPORT_FAILED_GENERATE = "generateProductReport_err_failed_reportGeneration";
	private  final String MSG_SAVE_GENERATE_CONTRAT_FAILED_SAVING = "save_generate_contrat_failed_saving";
	private final String MSG_RETRIEVE_GENERATE_CONTRAT_FAILED_RETRIEVING = "retrieve_generate_contrat_failed_retrieving";
	
	//------------- CREDIT FORM JASPER
	private  final String CREDITFORM_REPORT_CIVILITY = "CREDITFORM_REPORT_CIVILITY";
	private  final String CREDITFORM_REPORT_NAME = "CREDITFORM_REPORT_NAME";
	private  final String CREDITFORM_REPORT_SURNAME = "CREDITFORM_REPORT_SURNAME";
	private  final String CREDITFORM_REPORT_BORROWAMOUNT = "CREDITFORM_REPORT_BORROWAMOUNT";
	private  final String CREDITFORM_REPORT_REIMBURSEMENTDURATION = "CREDITFORM_REPORT_REIMBURSEMENTDURATION";
	private  final String CREDITFORM_REPORT_LOGO_KOOSSERY = "CREDITFORM_REPORT_LOGO_KOOSSERY";

	/* --------------- Report bytes  --------------- */
	private byte[] reportBytes;
	
	//Credit Form BAcking Bean
	CreditFormBackingBean creditRecordData = (CreditFormBackingBean) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "CreditFormBackingBean");
	
	//Generate Data
	GenerateContratData generateData = new GenerateContratData();
	
	/// ALfresco's Services
	private NodeService nodeService = (NodeService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "NodeService");
	private ServiceRegistry serviceRegistry = (ServiceRegistry)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ServiceRegistry");
	private TransactionService transactionService = serviceRegistry.getTransactionService();
	private FileFolderService fileFolderService = (FileFolderService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FileFolderService");
	private ContentService contentService = (ContentService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ContentService");
	private CustomManageTaskDialog manageTask = (CustomManageTaskDialog) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");

	public void execute(ExecutionContext arg0) throws Exception {
		super.execute(arg0);		
		
		AssociationRef assNode;
		
		int length = manageTask.getFirstElementPackage().split("/").length;

		String id = manageTask.getFirstElementPackage().split("/")[length-1];
		
		//Get NodeRef of Credit record
		NodeRef creditFormNode = new NodeRef(Repository.getStoreRef(), id);
		
		//init datat in Credit form Backing bean
		creditRecordData.setupContent(id);

		//we generate Contrat with Jasper
		generateContratWithJasperReport();
		
		//We save contrat
		saveGenerateContrat(reportBytes,creditFormNode);			
		
		//Set ressources
		manageTask.AddItemToPackageItemToAdd(generateData.getNodeRef().toString());
		manageTask.updateResources();
	}

	/**
	 * Generate Contrat via JAsper Report
	 */
	@SuppressWarnings("unchecked")
	private void generateContratWithJasperReport(){
	
		FacesContext fc = FacesContext.getCurrentInstance();		
			
		System.out.println("RAPH >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> creditFormData.getCreditRecordData().getName()"+creditRecordData.getCreditRecordData().getName());
		System.out.println("RAPH >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> creditFormData.getCreditRecordData().toString() "+creditRecordData.getCreditRecordData().toString());
		
		try {
			
			// - Parameters to send to the report
			Map parameters = new HashMap();
			/* Credit form Report */
			parameters.put(CREDITFORM_REPORT_CIVILITY, creditRecordData.getCreditRecordData().getCivility());
			parameters.put(CREDITFORM_REPORT_NAME, creditRecordData.getCreditRecordData().getName());
			parameters.put(CREDITFORM_REPORT_SURNAME, creditRecordData.getCreditRecordData().getSurname());
			parameters.put(CREDITFORM_REPORT_LOGO_KOOSSERY, new FileInputStream(JASPER_REPORT_KOOSSERY_LOGO_PATH.getFile()));			
			parameters.put(CREDITFORM_REPORT_BORROWAMOUNT, new Long(creditRecordData.getCreditRecordData().getBorrowAmount()).toString());
			parameters.put(CREDITFORM_REPORT_REIMBURSEMENTDURATION, new Long(creditRecordData.getCreditRecordData().getReimbursementDuration()).toString());

			File file = JASPER_REPORT_CONTEXT_PATH.getFile();
			 // - Chargement et compilation du rapport
            JasperDesign jasperDesign = JRXmlLoader.load(JRXML_REPORT_CONTEXT_PATH.getFile().getAbsolutePath());
            JasperReport jasperReport = JasperCompileManager.compileReport(jasperDesign);

			// - Execution
			FileInputStream modelJasper = new FileInputStream(file);
			JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters,new JREmptyDataSource());			
   
			//export to RTF File
			   ByteArrayOutputStream xlsReport = new ByteArrayOutputStream();
			    			   
			   JRRtfExporter exporter = new JRRtfExporter();
			    
			   exporter.setParameter(JRXlsExporterParameter.JASPER_PRINT,  jasperPrint);
			   exporter.setParameter(JRXlsExporterParameter.OUTPUT_STREAM,
			     xlsReport);
			   exporter.exportReport();
			   // Send response
			  reportBytes = xlsReport.toByteArray();

			
		} catch (Throwable e) {
			logger.error(Application.getMessage(fc, MSG_PRODUCT_REPORT_FAILED_GENERATE) + e.toString(), e);
		}
	}


	
	/**
	 * Save the Contrat generated
	 */
	private void saveGenerateContrat(byte[] bytes,NodeRef creditFormNode){
		FacesContext fc = FacesContext.getCurrentInstance();
						
	    LoginBackingBean loginFormData = (LoginBackingBean) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "LoginBean");		
	    UserTransaction tx = null;
	    
		String generateContratFile = "Contrat-Credit-Generated-"+System.currentTimeMillis()+".doc";
		String generateContratDescription ="Contrat Genarated by Legal pool";
		
		String mimeType = "text/rtf";
		//String objectType = CreditRecordModel.ASSOC_GENERATECONTRACTASPECT.toString();
		String objectType = CreditRecordModel.TYPE_GENERATECONTRAT.toString();
		String encoding = "UTF-8";
		
		try {
			
			//begin transaction
			tx = transactionService.getUserTransaction();
			tx.begin();

			//Set Credit Backing Bean Node
			creditRecordData.getCreditRecordData().setCreditRecordNodeRef(creditFormNode);			
			
			FileInfo fileInfo = fileFolderService.create(
					  this.creditRecordData.getCreditRecordData().getCreditRecordNodeRef(),
					  generateContratFile ,					  
			          Repository.resolveToQName(objectType));
			
			  NodeRef fileNodeRef = fileInfo.getNodeRef();
			  
			  //Set Document properties
			  nodeService.setProperty(fileNodeRef, ContentModel.PROP_NAME, generateContratFile);
			  nodeService.setProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION, generateContratDescription);
		    
			  // set the auditable aspect
			  Map<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
			  Date now = new Date();
			  String author = serviceRegistry.getAuthenticationService().getCurrentUserName();
			  nodeProperties.put(ContentModel.PROP_CREATOR, author);
			  nodeProperties.put(ContentModel.PROP_MODIFIER, author );
			  nodeProperties.put(ContentModel.PROP_CREATED, now);
			  nodeProperties.put(ContentModel.PROP_MODIFIED, now);

			  nodeService.addAspect(fileNodeRef, ContentModel.ASPECT_AUDITABLE, nodeProperties);
		    
			  // set the author aspect
			  Map<QName, Serializable> authorProps = new HashMap<QName, Serializable>(1, 1.0f);
			  authorProps.put(ContentModel.PROP_AUTHOR, author);
			  nodeService.addAspect(fileNodeRef, ContentModel.ASPECT_AUTHOR, authorProps);

			  System.out.println(" reportBytes : "+reportBytes);
			  System.out.println(" new ByteArrayInputStream(this.reportBytes) : "+new ByteArrayInputStream(this.reportBytes));
			  //Set value of bytes data
				this.generateData.setInputStream(new ByteArrayInputStream(this.reportBytes));
				
				//Try to get the Guess Encoding
				InputStream is = null;							
				try{
					is = new BufferedInputStream(this.generateData.getInputStream());
					encoding = Repository.guessEncoding(fc, is, mimeType);
				}catch (Throwable e){
					  logger.error("Failed to get encoding", e);
				}finally{
					try { is.close(); } catch (Throwable e) {} 
				}
			  // get a writer for the content and put the file
			  ContentWriter writer = contentService.getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
			  // set the mimetype and encoding
			  writer.setMimetype(mimeType);
			  writer.setEncoding(encoding);
		    
			  writer.putContent(this.generateData.getInputStream());
			  //set Generate Data NodeRef
			  this.generateData.setNodeRef(fileNodeRef);
			  
			// Set association
		    nodeService.createAssociation(creditRecordData.getCreditRecordData().getCreditRecordNodeRef(), this.generateData.getNodeRef(), CreditRecordModel.ASSOC_GENERATECONTRACTASPECT);
			  tx.commit();
		} catch (Throwable e) {
			logger.error(Application.getMessage(fc, MSG_SAVE_GENERATE_CONTRAT_FAILED_SAVING) + e.toString(), e);
		} 	
	}
}
