package com.koossery.workflow.credit.handler.resultsimulation;

import java.util.List;

import javax.faces.context.FacesContext;

import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.handler.common.DocumentStateActionHandler;
import com.koossery.workflow.credit.model.CreditRecordModel;
import com.koossery.workflow.credit.util.CreditConstant;
 
/**
 *  prepare les proprits statusDocument et piecesNumber pour qu'elles soit affiches dans le dashbord
 *  
 *  l'affichage des ces proprits sera contrle dans la jsp de custom..task-to-do ...jsp
 * @author Prosper_2
 *
 */

public class ResultSimulationActionHandler extends DocumentStateActionHandler {
	public static Logger logger = Logger.getLogger(ResultSimulationActionHandler.class.toString()); 
	
	public void execute(ExecutionContext arg0) throws Exception {
		
		super.execute(arg0);
		
		// TODO Auto-generated method stub
		
		Long pieceNumber =  new Long(0); 
		pieceNumber = (Long)arg0.getVariable(CreditConstant.SIMULATION_PIECE_NUMBER);
		
		if(pieceNumber == null){
			pieceNumber =  new Long(0);			
		}
			
		
		if(pieceNumber.longValue() < 2){
			pieceNumber =  new Long(0);					
			//obtention des donnes du manage task pour obtenir les donnes du credit s'affichant sur l'interface
			CustomManageTaskDialog manageTask = (CustomManageTaskDialog) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
			
			NodeService nodeService = (NodeService) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "NodeService");
			
			int length = manageTask.getFirstElementPackage().split("/").length;

			String id = manageTask.getFirstElementPackage().split("/")[length-1];

			System.out.println("ResultSimulationActionHandler >>>>>>>>>>>>>>>>>>>>>>>  id: "+id);
			NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), id);	
			
			List<AssociationRef> assocRefs = nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
			DictionaryService dd = Repository.getServiceRegistry(
		              FacesContext.getCurrentInstance()).getDictionaryService();

			System.out.println("ResultSimulationActionHandler >>>>>>>>>>>>>>>>>>>>>>>  assocRefs: "+assocRefs);
			if(assocRefs != null){						
				for (AssociationRef associationRef : assocRefs) {
					// Scan SLIP piece
					if(associationRef.getTargetRef() != null){
						if(dd.isSubClass(nodeService.getType(associationRef.getTargetRef()), CreditRecordModel.PROP_SCANPAYSLIP)){								
							pieceNumber++;
							System.out.println("ResultSimulationActionHandler >>>>>>>>>>>>>>>>>>>>>>>  associationRef.getTargetRef(): "+associationRef.getTargetRef());
						}		
						
						//Scan Tax Piece
						if(dd.isSubClass(nodeService.getType(associationRef.getTargetRef()), CreditRecordModel.PROP_SCANTAXSLIP)){								
							pieceNumber++;
							System.out.println("ResultSimulationActionHandler >>>>>>>>>>>>>>>>>>>>>>>  associationRef.getTargetRef(): "+associationRef.getTargetRef());
						}	
				    }
				}
			}
			arg0.setVariable(CreditConstant.SIMULATION_PIECE_NUMBER, pieceNumber.longValue());
		}
		
	}

}
