package com.koossery.workflow.credit.handler.simulation;

/**
 * @author Raphael
 */
import org.alfresco.repo.module.LoggerModuleComponent;
import org.alfresco.web.app.servlet.FacesHelper;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import javax.faces.context.FacesContext;
import javax.xml.bind.ParseConversionEvent;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;
import com.koossery.workflow.credit.util.CreditConstant;
import com.koossery.workflow.credit.util.KTCreditRecordUtil;

/*
 * Avant de donner la mthodologie utilise sur laquelle nous allons bas notre Simulation,
 * Nous allons dabord donner les champs du CreditForm sur lesquels nous nous appuyons.
 * Nous allons utiliser les champs:  childNumberInCharge, borrowAmount, 
 * 			reimbursementDuration(en mois),monthlySalary.
 *  
 * Voici les conditions de la simulation:
 *  1/ reimbursementDuration <= 36 month
 *  2/  Nous allons suppos que la variable NetSalary contient la somme d'argent utilise par mois, 
 *        pour rembourser la Banque.
 *  	On a : NetSalary = monthlySalary- personnelConsumption - childInChargeConsumption - otherChargeConsumption
 *  							o childInChargeConsumption  = childNumberInCharge*childConsumption
 *  	Donc, la condition est la suivante:
 *  			NetSalary*reimbursementDuration >=  borrowAmount
 */
public  class SimulationActionHandler implements ActionHandler {

	/**
	 * cette mthode permet de lancer  la simulation
	 */
	public void execute(ExecutionContext arg0) throws Exception {
		

		arg0.setVariable(CreditConstant.SIMULATION_DOCUMENT_STATE, KTCreditRecordUtil.simulationCreditRecord());
		
		System.out.println("RAPH>>>>>>>>>>>>>>>>>>>>>>> public void execute(ExecutionContext arg0) throws Exception { : "+arg0.getVariable(CreditConstant.SIMULATION_DOCUMENT_STATE));
	}

}
