package com.koossery.workflow.credit.model;

import org.alfresco.service.namespace.QName;

public interface CreditRecordModel {

    static final String WORKFLOWCREDIT_MODEL_URI = "http://www.koossery-tech.com/model/wc/1.0";
    static final String WORKFLOWCREDIT_MODEL_PREFIX = "wc";
    
    static final QName NAME = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "CreditModel");
    
  //Types
    static final QName TYPE_CREDITRECORD = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "creditRecord");
    static final QName TYPE_TEMPLATE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "template");

    //Association
    static final QName ASSOC_GENERATECONTRACTASPECT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "hasGenerateContrat");

  
    // ASPECT_SCANCONTRACTASPECT Properties
    static final QName TYPE_SCANCONTRAT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "scanContrat");
    static final QName TYPE_SCANTAXSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "scanTaxSlip");
    static final QName TYPE_SCANPAYSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "scanPaySlip");
    // ASPECT_GENERATECONTRACTASPECT Properties
    static final QName TYPE_GENERATECONTRAT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "generateContrat");
  
   // TYPE_CREDITRECORD Properties
    static final QName PROP_CIVILITY = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "civility");
    static final QName PROP_NAME = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "name");
    static final QName PROP_SURNAME = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "surname");
    static final QName PROP_BIRTHDATE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "birthdate");
    static final QName PROP_CNI = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "cni");
    static final QName PROP_FAMILYSITUATION = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "familySituation");
    static final QName PROP_CHILDNUMBER = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "childNumber");
    static final QName PROP_CHILDNUMBERINCHARGE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "childNumberInCharge");
    static final QName PROP_EMAIL = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "email");
    static final QName PROP_PROFESSIONNELSITUATION = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "professionnelSituation");
    static final QName PROP_SINCE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "since");
    static final QName PROP_BORROWAMOUNT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "borrowAmount");
    static final QName PROP_REIMBURSEMENTDURATION = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "reimbursementDuration");
    static final QName PROP_MONTHLYSALARY = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "monthlySalary");
    static final QName PROP_LOANTYPE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "loanType");
    static final QName PROP_DISBURSEMENTTYPE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "disbursementType");
    static final QName PROP_COUNTNUMBER = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "countNumber");
    static final QName PROP_STATEDOCUMENT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "stateDocument");
    static final QName PROP_SCANPAYSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "scanPaySlip");
    static final QName PROP_SCANTAXSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "scanTaxSlip");
    
    // TYPE_TEMPLATE Properties
    static final QName PROP_LIBELLE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "libelle");
    static final QName PROP_DESCRIPTION = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "description");
    static final QName PROP_FILE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "file");
    
  //The association
    static final QName ASSOC_HASTEMPLATE = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "hasTemplate");
    static final QName ASSOC_HASSCANPAYSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "hasScanPaySlip");
    static final QName ASSOC_HASSCANTAXSLIP = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "hasScanTaxSlip");
    static final QName ASSOC_HASSCANCONTRAT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "hasScanContrat");
  
   // The constraints
    static final QName CONST_VALUECIVILITY = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "valueCivility");
    static final QName CONST_VALUEFAMILYSITUATION = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "valueFamilySituation");
    static final QName CONST_VALUETYPELOAN = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "valueTypeLoan");
    static final QName CONST_VALUETYPEDISBURSEMENT = QName.createQName(WORKFLOWCREDIT_MODEL_URI, "valueTypeDisbursement");

    static final QName CPROP_MIMETYPE = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"mimetype");
    static final QName CPROP_ENCODING = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"encoding");
    static final QName CPROP_AUTHOR = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"author");
    static final QName CPROP_DESCRIPTION = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"description");
    static final QName CPROP_INPUTSTEAM = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"inputStream");
    static final QName CPROP_NAME = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"name");
    static final QName CPROP_OBJECTYPE = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"objectTye");
    static final QName CPROP_TITLE = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"title");
    static final QName CPROP_CREATER = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"creater");
    static final QName CPROP_CREATED = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"created");
    static final QName CPROP_MODIFER = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"modifer");
    static final QName CPROP_MODIFIED = QName.createQName(WORKFLOWCREDIT_MODEL_URI,"modified");
  
}
