package com.koossery.workflow.credit.util;

import java.util.UUID;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.koossery.workflow.credit.backingbean.creditform.CreditFormBackingBean;
import com.koossery.workflow.credit.backingbean.managetask.CustomManageTaskDialog;

public class KTCreditRecordUtil {
	
	private static final Log logger = LogFactory.getLog(KTCreditRecordUtil.class);
	
	public static String getDocumentId()
	{
		return  "CreditRecord_"+System.currentTimeMillis();
		
	}
		// Current Container node reference
		private static NodeRef containerNodeRef;	
	/**
		 * Gets current container node reference
		 * @return
		 */
		public static NodeRef getCurrentContainerNodeRef(){
			
			FacesContext fc = FacesContext.getCurrentInstance();
				
			NavigationBean navBean = (NavigationBean)fc.getExternalContext().getSessionMap().get(NavigationBean.BEAN_NAME);
			containerNodeRef = navBean.getCurrentNode().getNodeRef();
			
			return containerNodeRef;
		}
		
		public static NodeRef getGuestHome(){
			FacesContext fc = FacesContext.getCurrentInstance();
			
			NavigationBean navBean = (NavigationBean)fc.getExternalContext().getSessionMap().get(NavigationBean.BEAN_NAME);
			return navBean.getGuestHomeNode().getNodeRef();
		
		}	
		
		   /**
		    * Adds a global error message
		    * 
		    * @param msg        The error message
		    */
		   public static void addErrorMessage(String msg)
		   {
		      addErrorMessage(msg, null);
		   }
		   
		   /**
		    * Adds a global error message and logs exception details
		    * 
		    * @param msg        The error message
		    * @param err        The exception to log
		    */
		   public static void addErrorMessage(String msg, Throwable err)
		   {
		      FacesContext context = FacesContext.getCurrentInstance( );
		      FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
		      context.addMessage(null, facesMsg);
		      if (err != null)
		      {
		         if ((err instanceof InvalidNodeRefException == false &&
		              err instanceof AccessDeniedException == false &&
		              err instanceof NoTransformerException == false) || logger.isDebugEnabled())
		         {
		            logger.error(msg, err);
		         }
		      }
		   }
		   
/*
* Avant de donner la mthodologie utilise sur laquelle nous allons bas notre Simulation,
* Nous allons dabord donner les champs du CreditForm sur lesquels nous nous appuyons.
* Nous allons utiliser les champs:  childNumberInCharge, borrowAmount, 
* 			reimbursementDuration(en mois),monthlySalary.
*  
* Voici les conditions de la simulation:
*  1/ reimbursementDuration <= 36 month
*  2/  Nous allons suppos que la variable NetSalary contient la somme d'argent utilise par mois, 
*        pour rembourser la Banque.
*  	On a : NetSalary = monthlySalary- personnelConsumption - childInChargeConsumption - otherChargeConsumption
*  							o childInChargeConsumption  = childNumberInCharge*childConsumption
*  	Donc, la condition est la suivante:
*  			NetSalary*reimbursementDuration >=  borrowAmount
*/		   
		   public static String simulationCreditRecord(){

				//obtention des donnes du backing bean
				CreditFormBackingBean creditFormData = (CreditFormBackingBean) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "CreditFormBackingBean");
				//obtention des donnes du manage task pour obtenir les donnes du credit s'affichant sur l'interface
				CustomManageTaskDialog manageTask = (CustomManageTaskDialog) FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ManageTaskDialog");
				
				int length = manageTask.getFirstElementPackage().split("/").length;

				String id = manageTask.getFirstElementPackage().split("/")[length-1];
							
				creditFormData.setupContent(id);
				
				Double netSalary = 0.0;
				boolean condition1 = false;
				boolean condition2 = false;
				
				//1/
				condition1 = ((creditFormData.getCreditRecordData().getReimbursementDuration()<=36)&&(creditFormData.getCreditRecordData().getReimbursementDuration()>0));
				
				//2/
				netSalary = creditFormData.getCreditRecordData().getMonthlySalary() - CreditConstant.SIMULATION_PERSONNEL_CONSUMPTION - creditFormData.getCreditRecordData().getChildNumberInCharge()*CreditConstant.SIMULATION_CHILD_IN_CHARGE_CONSUMPTION-CreditConstant.SIMULATION_OTHER_CHARGE_CONSUMPTION;

				condition2 =  netSalary * creditFormData.getCreditRecordData().getReimbursementDuration()>= creditFormData.getCreditRecordData().getBorrowAmount();
				
				//decision
				if(condition1 && condition2){
				
					return CreditConstant.CREDIT_FORM_STATE_DOCUMENT_GREEN;
				}
				else {
					return CreditConstant.CREDIT_FORM_STATE_DOCUMENT_RED;
				}
		   }
}
